% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/dicom.R
\name{readDICOM}
\alias{readDICOM}
\title{Read All DICOM Files in a Directory}
\usage{
readDICOM(path, recursive = TRUE, exclude = NULL, verbose = FALSE,
  counter, ...)
}
\arguments{
\item{path}{Path name to the DICOM directory.}

\item{recursive}{Search recursively down from the given path name.}

\item{exclude}{Exclude file names containing this character string.}

\item{verbose}{Flag to provide text-based progress bar.}

\item{counter}{Ignored.}

\item{...}{Arguments to be passed to \code{readDICOMFile}.}
}
\value{
A list structure with two major components: \item{img}{All images
associated with the DICOM directory(ies).} \item{hdr}{All header files
associated with the DICOM directory(ies).}
}
\description{
All DICOM files are imported and a text file summarizing their content
recorded.
}
\details{
A \code{for} loop is used to process each DICOM file contained in the
directory(ies).  If only a single file is specified in the path,
\code{readDICOM} will read that file only.
}
\examples{
## pixelData = TRUE
## The DICOM image data are read from readDICOM()

\dontrun{
dcmSphere <- readDICOM(system.file("sphere3", package="oro.dicom"), verbose=TRUE)
}
}
\author{
Brandon Whitcher \email{bwhitcher@gmail.com}
}
\references{
Whitcher, B., V. J. Schmid and A. Thornton (2011).  Working with
the DICOM and NIfTI Data Standards in R, \emph{Journal of Statistical
Software}, \bold{44} (6), 1--28.  \url{http://www.jstatsoft.org/v44/i06}

Digital Imaging and Communications in Medicine (DICOM)\cr
\url{http://medical.nema.org}
}
\seealso{
\code{\link{readDICOMFile}}
}
\keyword{file}

