% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ordinalCont.R
\docType{data}
\name{ANZ0001}
\alias{ANZ0001}
\title{ANZ0001 trial}
\format{A data frame with 2473 rows and 11 variables}
\usage{
data(ANZ0001)
}
\description{
The complete ANZ0001 trial data set
}
\details{
The ANZ0001 trial, conducted by the ANZ Breast Cancer Trials Group, is an unblinded, multi-centre, 
randomized trial with three chemotherapy treatment arms, concluded in 2005 (Stockler et al 2007). 
Health-related quality of life measures (Overall quality of life, Physical Well-Being, Mood, Pain, Nausea and 
Vomiting, Appetite) are assessed at each chemotherapy treatment cycle, from randomization until 
disease progression, when treatment is interrupted. 
The treatments Intermittent Capecitabine (IC) and Continuous Capecitabine (CC) are compared with the 
standard combination treatment CMF, each with its own protocol. 
There is no maximum duration of treatment, but it is interrupted on disease progression, or when patient 
intolerance or unacceptable toxicity are recorded.
The data set is extracted from the ANZ0001 trial and contains information from 292 patients with complete 
quality of life measurements.

The variables are as follows:

\tabular{ll}{
\code{randno}\tab patient ID number \cr
\code{cycleno}\tab chemotherapy cycle number \cr
\code{age}\tab age of patient at entry to study \cr
\code{bsa}\tab Body Surface Area (m\eqn{^2}) \cr
\code{treatment}\tab  treatment received by  patient (1,2,3)\cr
\code{overall}\tab Overall quality of life as recorded by the patient on a LASA scale,  normalized to  (0, 1)\cr
\code{phys}\tab Physical Well-Being as recorded by the patient on a LASA scale,  normalized to  (0, 1)\cr
\code{mood}\tab Mood as recorded by the patient on a LASA scale,  normalized to  (0, 1)\cr
\code{pain}\tab Pain as recorded by the patient on a LASA scale,  normalized to  (0, 1)\cr
\code{nausvom}\tab Nausea and Vomiting as recorded by the patient on a LASA scale,  normalized to  (0, 1)\cr
\code{appetite}\tab Appetite as recorded by the patient on a LASA scale,  normalized to  (0, 1)
}
}
\references{
Stockler, M., T. Sourjina, P. Grimison, V. Gebski, M. Byrne, V. Harvey, P. Francis et al. 
``A randomized trial of capecitabine (C) given intermittently (IC) rather than continuously (CC) compared 
to classical CMF as first-line chemotherapy for advanced breast cancer (ABC).'' In \emph{ASCO Annual Meeting 
Proceedings}, vol. 25, no. 18_suppl, p. 1031. 2007.
}
\keyword{datasets}
