% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ocm.methods.R
\name{print.anova.ocm}
\alias{print.anova.ocm}
\title{Print anova.ocm objects}
\usage{
\method{print}{anova.ocm}(x, digits = max(getOption("digits") - 2, 3),
  signif.stars = getOption("show.signif.stars"), ...)
}
\arguments{
\item{x}{an object of class \code{anova.ocm}}

\item{digits}{controls the number of digits to print. Defaults to the maximum of the value
returned by (getOption("digits") - 2) and 3}

\item{signif.stars}{a logical. Should the significance stars be printed? Defaults to the value
returned by getOption("show.signif.stars")}

\item{...}{further arguments passed to or from other methods}
}
\value{
Prints \code{anova.ocm} object
}
\description{
Print the results of the comparison of continuous ordinal models in likelihood ratio tests.
}
\examples{
ANZ0001.ocm <- ANZ0001[ANZ0001$cycleno==0 | ANZ0001$cycleno==5,]
ANZ0001.ocm$cycleno[ANZ0001.ocm$cycleno==5] <- 1
fit.overall  <- ocm(overall  ~ cycleno + bsa + treatment, data=ANZ0001.ocm)
anova(fit.overall, update(fit.overall, .~. + age))
}
\author{
Maurizio Manuguerra, Gillian Heller
}
\seealso{
\code{\link{ocm}}, \code{\link{anova.ocm}}
}
\keyword{anova}
\keyword{summary,}

