% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ocm.R
\name{ocm}
\alias{ocm}
\title{Ordinal regression for continuous scales}
\usage{
ocm(formula, data = NULL, weights, start = NULL, link = c("logit"),
  gfun = c("glf"), method = c("optim", "ucminf"))
}
\arguments{
\item{formula}{a formula expression as for regression models, of the form
response ~ predictors. Only fixed effects are supported.
The model must have an intercept: attempts to remove one will lead to a warning and will be
ignored.}

\item{data}{an optional data frame in which to interpret the variables occurring in the
formulas}

\item{weights}{optional case weights in fitting. Defaults to 1.}

\item{start}{a vector of initial values for the regression coefficients
and \code{M},  \code{B}, \code{T}, (offset, slope and symmetry of the g function)}

\item{link}{link function, i.e. the type of location-scale distribution assumed for the latent
distribution. The default ``logit'' link gives the proportional odds model and is the only link function currently supported.}

\item{gfun}{A smooth monotonic function capable of capturing the non-linear nature of the
ordinal measure. It defaults to the generalized logistic function, which is currently the only
possibility.}

\item{method}{The optimizer used to maximize the likelihood function.}
}
\value{
an object of type \code{ocm} with the components listed below. Parameter estimates are in \code{coefficients}.
The last 3 elements of \code{coefficients} are the parameters of the g function:
\code{M},  \code{B},  and \code{T}.
\item{coefficients}{parameter estimates}
\item{vcov}{variance-covariance matrix}
\item{df}{estimated degrees of freedom}
\item{logLik}{value of the log-likelihood at the estimated optimum}
\item{len_beta}{number of fixed-effects parameters of the model}
\item{len_gfun}{number of parameters in the g function used in the model}
\item{fitted.values}{fitted probabilities}
\item{residuals}{residuals on the latent scale}
\item{v}{vector of continuous scores}
\item{x}{model matrix}
\item{sample.size}{sample size (can differ from the number of observations if the weights are different from 1)}
\item{nobs}{number of observations}
\item{call}{call to fit the model}
\item{no.pars}{total number of parameters estimated}
\item{data}{data frame used}
\item{link}{link function used}
\item{gfun}{g function used}
\item{formula}{formula used}
}
\description{
Continuous ordinal regression with logit link using the
generalized logistic function as g function.
}
\details{
Fits a continuous ordinal regression model, with fixed effects. The g function is the generalized logistic function (see \code{\link{g_glf}}), and the link function is the logit,
implying the standard logistic distribution for the latent variable. Maximum likelihood estimation is performed, using \code{optim {stats}} with a quasi-Newton method (\code{"BFGS"}).
For continuous ordinal mixed modelling, see \code{\link{ocmm}}.
}
\examples{
ANZ0001.ocm <- ANZ0001[ANZ0001$cycleno==0 | ANZ0001$cycleno==5,]
ANZ0001.ocm$cycleno[ANZ0001.ocm$cycleno==5] <- 1
fit.overall  <- ocm(overall  ~ cycleno + age + bsa + treatment, data=ANZ0001.ocm)
fit.phys 	  <- ocm(phys 	  ~ cycleno + age + bsa + treatment, data=ANZ0001.ocm)
fit.pain 	  <- ocm(pain 	  ~ cycleno + age + bsa + treatment, data=ANZ0001.ocm)
fit.mood 	  <- ocm(mood 	  ~ cycleno + age + bsa + treatment, data=ANZ0001.ocm)
fit.nausvom  <- ocm(nausvom  ~ cycleno + age + bsa + treatment, data=ANZ0001.ocm)
fit.appetite <- ocm(appetite ~ cycleno + age + bsa + treatment, data=ANZ0001.ocm)
summary(fit.overall)
summary(fit.phys)
summary(fit.pain)
summary(fit.mood)
summary(fit.nausvom)
summary(fit.appetite)
par(mfrow=c(2,3))
plot(fit.overall, CIs='vcov', R=100)
plot(fit.phys, CIs='vcov', R=100)
plot(fit.pain, CIs='vcov', R=100)
plot(fit.mood, CIs='vcov', R=100)
plot(fit.nausvom, CIs='vcov', R=100)
plot(fit.appetite, CIs='vcov', R=100)
par(mfrow=c(1,1))
}
\author{
Maurizio Manuguerra, Gillian Heller
}
\references{
Manuguerra M, Heller GZ (2010). Ordinal Regression Models for Continuous
 Scales, \emph{The International Journal of Biostatistics}: 6(1), Article 14.
}
\seealso{
For continuous ordinal mixed models, see \code{\link{ocmm}}
}
\keyword{likelihood,}
\keyword{log-likelihood,}
\keyword{ordinal}
\keyword{regression.}

