% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/exactMatch.R
\name{antiExactMatch}
\alias{antiExactMatch}
\title{Specify a matching problem where units in a common factor cannot be matched.}
\usage{
antiExactMatch(x, z)
}
\arguments{
\item{x}{A factor across which matches should be allowed.}

\item{z}{A treatment indicator factor (a numeric vector of 1 and 0,
a logical vector, or a 2 level factor).}
}
\value{
A distance specification that encodes the across factor level constraint.
}
\description{
This function builds a distance specification where treated units
are infinitely far away from control units that share the same
level of a given factor variable. This can be useful for ensuring
that matched groups come from qualitatively different groups.
}
\details{
The \code{\link{exactMatch}} function provides a way of specifying
a matching problem where only units within a factor level may be
matched. This function provides the reverse scenario: a matching
problem in which only units across factor levels are permitted to
match. Like \code{\link{exactMatch}}, the results of this function will
most often be used as a \code{within} argument to
\code{\link{match_on}} or another distance specification creation
function to limit the scope of the final distance specification
(i.e., disallowing any match between units with the same value on
the factor variable \code{x}).
}
\examples{
data(nuclearplants)

# force entries to be within the same factor:
em <- fullmatch(exactMatch(pr ~ pt, data = nuclearplants), data = nuclearplants)
table(nuclearplants$pt, em)

# force treated and control units to have different values of `pt`:
z <- nuclearplants$pr
names(z) <- rownames(nuclearplants)
aem <- fullmatch(antiExactMatch(nuclearplants$pt, z), data = nuclearplants)
table(nuclearplants$pt, aem)
}
\seealso{
\code{\link{exactMatch}}, \code{\link{match_on}}, \code{\link{caliper}}, \code{\link{fullmatch}}, \code{\link{pairmatch}}
}

