% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cost_funs.R
\name{cost_fun}
\alias{cost_fun}
\title{Compute the instantaneous cost of raising hatchery fish}
\usage{
cost_fun(
  time,
  recruits,
  init_cost,
  time_slope = 0,
  time_exp = 1,
  rec_slope = 1,
  rec_exp = 1,
  type = "multiplicative"
)
}
\arguments{
\item{time}{The time at which fish are raised in hatchery}

\item{recruits}{The number of recruits raised}

\item{init_cost}{Baseline initial cost to raise a single fish}

\item{time_slope}{The slope term on the amount of time (see details)}

\item{time_exp}{The exponent on the amount of time}

\item{rec_slope}{The slope term on the number of recruits}

\item{rec_exp}{The exponent on the number of recruits}

\item{type}{Either multiply the number of recruits times the cost-at-time or
add to it (see Details).}
}
\value{
A numeric value representing the cost of rearing the number of
\code{recruits} at a given time and given the number of recruits raised
}
\description{
This is a multivariable function of both time and number of recruits raised.
Cost-per-time and cost-per-recruit can be calculated as a quadratic
where the slope and exponent can be specified.
}
\details{
The cost-per-fish based on time and number of recruits uses the function:

\ifelse{html}{
 \out{<i>C = s<sub>T</sub>t<sup>&alpha;</sup>
      * s<sub>2</sub>R<sup>&beta;</sup> + b</i>}}{
 \deqn{C = s_1 T^{\alpha} \cdot s_2 R^{\beta} + b}
}

if type = "multiplicative". Otherwise it uses:

\ifelse{html}{
 \out{<i>C = s<sub>T</sub>t<sup>&alpha;</sup>
      + s<sub>2</sub>R<sup>&beta;</sup> + b</i>}}{
 \deqn{C = s_1 T^{\alpha} + s_2 R^{\beta} + b}
}

if type = "additive"

where C = the cost to rear R number of recruits at time T,
the s values are the slopes, \ifelse{html}{\out{&alpha;}}{\eqn{\alpha}} and
\ifelse{html}{\out{&beta;}}{\eqn{\beta}}, are the exponents on time (T) and
recruits (R), respectively, and b is the intercept.
The instantaneous cost is really what is of interest, and the number of
recruits essentially adjusts the intercept on that dimension of the equation.

Increasing the exponent will dramatically increase the cost of raising
hatchery fish as time goes on. Increasing the exponent dramatically
increases the cost of raising a greater number of fish. Integrating this
equation across time will compute the total cost to raise the number of
\code{recruits} to time T. Use the \code{\link{total_cost}} function to
do this automatically.
}
\examples{
# compute the instantaneous cost of raising 1000 fish on day 100
cost_fun(time = 100, recruits = 1000, init_cost = 0.05,
         time_slope = 0, time_exp = 1,
         rec_slope = 0.01, rec_exp = 1)
# plot a curve of instantaneous cost against time
curve(cost_fun(x, 1000, 0.05, 0.01, 1.2, 0.05, 1), 0, 1000,
      xlab = "Time", ylab = "$")
\dontrun{
# 3d plot of costs by time and recruit
emdbook::curve3d(cost_fun(x, y, 0.05, 0.01, 1.2, 0.05, 1),
                 from = c(0, 0),
                 to = c(1000, 1000),
                 xlab = "Time", ylab = "Recruits",
                 zlab = "$", sys3d = "wireframe")
}
}
