% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/legacy.R
\name{define_optimizer}
\alias{define_optimizer}
\alias{optimizer_nlm}
\alias{optimizer_optim}
\title{Specify numerical optimizer}
\usage{
define_optimizer(
  .optimizer,
  .objective,
  .initial,
  .value,
  .parameter,
  .direction,
  ...,
  .output_ignore = character(0),
  .validate = FALSE,
  .validation_settings = list(objective_test = TestFunctions::TF_ackley, objective_add =
    list(), initial = round(stats::rnorm(2), 2), check_seconds = 10)
)

optimizer_nlm(
  ...,
  .output_ignore = character(0),
  .validate = FALSE,
  .validation_settings = list()
)

optimizer_optim(
  ...,
  .direction = "min",
  .output_ignore = character(0),
  .validate = FALSE,
  .validation_settings = list()
)
}
\arguments{
\item{.optimizer}{A \code{function}, a numerical optimizer. Four conditions must be met:
\enumerate{
\item It must have an input named \code{.objective} for a \code{function}, the
objective function which is optimized over its first argument.
\item It must have an input named \code{.initial} for a \code{numerical}
vector, the initial parameter vector.
\item It must have a \code{...} argument for additional parameters to
the objective function.
\item The output must be a named \code{list}, including the optimal function
value and the optimal parameter vector.
}}

\item{.objective}{A \code{character}, the name of the function input of \code{optimizer}.}

\item{.initial}{A \code{character}, the name of the starting parameter values input of
\code{optimizer}.}

\item{.value}{A \code{character}, the name of the optimal function value in the output list
of \code{optimizer}.}

\item{.parameter}{A \code{character}, the name of the optimal parameter vector in the output
list of \code{optimizer}.}

\item{.direction}{A \code{character}, indicates whether the optimizer minimizes (\code{"min"})
or maximizes (\code{"max"}).}

\item{...}{Additional arguments to be passed to the optimizer. Without
specifications, the default values of the optimizer are used.}

\item{.output_ignore}{A \code{character} vector of element names in the output of \code{.optimizer}
that are not saved. The elements \code{.value} and \code{.parameter} are
added automatically to \code{.output_ignore}, because they are saved
separately, see the output documentation of \code{\link{apply_optimizer}}.}

\item{.validate}{A \code{logical}, set to \code{TRUE} (\code{FALSE}) to (not) validate the
\code{optimizer} object.
By default, \code{.validate = FALSE}.}

\item{.validation_settings}{Ignored if \code{.valdiate = FALSE}.
Otherwise, a \code{list} of validation settings:
\describe{
\item{objective_test}{A \code{function}, the test function to be optimized.
By default, it is the
\href{https://en.wikipedia.org/wiki/Ackley_function}{Ackley function}.}
\item{objective_add}{A \code{list} of additional arguments to
\code{objective_test} (if any).
By default, \code{objective_add = list()}, because the default function
for \code{objective_test} does not have additional arguments.}
\item{initial}{A \code{numeric} vector, the initial values for the
optimization of \code{objective_test}.
By default, \code{initial = round(stats::rnorm(2), 2)}.}
\item{check_seconds}{An \code{integer}, the maximum number of seconds
before the test is aborted.
The test call is considered to be successful if no error occurred
within \code{check_seconds} seconds.
By default, \code{check_seconds = 10}.}
}}
}
\value{
An \code{optimizer} object.
}
\description{
This function specifies the framework for a numerical optimizer.

Two wrappers for well-known optimizers are already available:
\enumerate{
\item \code{optimizer_nlm()} for the \code{\link[stats]{nlm}} optimizer
\item \code{optimizer_optim()} for the \code{\link[stats]{optim}} optimizer
}
}
\section{Format}{
An \code{optimizer} object is a \code{list} of six elements:
\describe{
\item{optimizer}{A \code{function}, the optimization algorithm.}
\item{optimizer_name}{A \code{character}, the name of
\code{optimizer}.}
\item{optimizer_arguments}{A named \code{list}, where each element
is an additional function argument for \code{optimizer}.}
\item{optimizer_direction}{Either \code{"min"} if the optimizer minimizes
or \code{"max"} if the optimizer maximizes.}
\item{optimizer_labels}{A named \code{list} of four
\code{character}:
\describe{
\item{objective}{the name of the function input of \code{optimizer}}
\item{initial}{the name of the starting parameter values input of
\code{optimizer}}
\item{value}{the name of the optimal function value in the output list
of \code{optimizer}}
\item{parameter}{the name of the optimal parameter vector in the
output list of \code{optimizer}.}
}}
\item{output_ignore}{A \code{character} vector of element
names in the output \code{list} of \code{optimizer} that are ignored.
The elements \code{value} and \code{parameter} are added automatically to
\code{output_ignore}, because they are saved
separately, see the output documentation of \code{\link{apply_optimizer}}.}
}
}

\examples{
define_optimizer(
  .optimizer = pracma::nelder_mead,           # optimization function
  .objective = "fn",                          # name of function input
  .initial = "x0",                            # name of initial input
  .value = "fmin",                            # name of value output
  .parameter = "xmin",                        # name of parameter output
  .direction = "min",                         # optimizer minimizes
  .output_ignore = c("restarts", "errmess"),  # ignore some outputs
  tol = 1e-6,                                 # additional optimizer argument
  .validate = TRUE                            # validate the object
)
}
\seealso{
Use \code{\link[=apply_optimizer]{apply_optimizer()}} to apply an \code{optimizer} object for numerical
optimization.
}
