% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Solver-proto.R, R/add_gurobi_solver.R,
%   R/add_heuristic_solver.R, R/add_lpsolveapi_solver.R,
%   R/add_lpsymphony_solver.R, R/add_random_solver.R, R/add_rsymphony_solver.R
\docType{class}
\name{Solver-class}
\alias{Solver-class}
\alias{Solver}
\alias{GurobiSolver-class}
\alias{HeuristicSolver-class}
\alias{LpsolveapiSolver-class}
\alias{LpsymphonySolver-class}
\alias{RandomSolver-class}
\alias{RsymphonySolver-class}
\title{Solver prototype}
\description{
This prototype is used to generate objects that represent methods for solving
optimization problems. \strong{This class represents a recipe to
create solver and and is only recommended for use by expert users. To
customize the method used to solve optimization problems, please see the
help page on \link{solvers}}.
}
\section{Fields}{


\describe{

\item{$name}{\code{character} name of solver.}

\item{$parameters}{\code{Parameters} object with parameters used to customize
the the solver.}

\item{$solve}{\code{function} used to solve a
\linkS4class{OptimizationProblem} object.}
}
}

\section{Usage}{


\code{x$print()}

\code{x$show()}

\code{x$repr()}

\code{x$solve(op)}
}

\section{Arguments}{

\describe{

\item{x}{\linkS4class{Solver} object.}

\item{op}{\linkS4class{OptimizationProblem} object.}

}
}

\section{Details}{


\describe{
\item{print}{print the object.}

\item{show}{show the object.}

\item{repr}{\code{character} representation of object.}

\item{solve}{solve an \linkS4class{OptimizationProblem} using this
object.}

}
}

