% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pugixml.R
\name{read_xml}
\alias{read_xml}
\title{read xml file}
\usage{
read_xml(
  xml,
  pointer = TRUE,
  escapes = FALSE,
  declaration = FALSE,
  whitespace = TRUE,
  empty_tags = FALSE,
  skip_control = TRUE
)
}
\arguments{
\item{xml}{something to read character string or file}

\item{pointer}{should a pointer be returned?}

\item{escapes}{bool if characters like "&" should be escaped. The default is
no escapes. Assuming that the input already provides valid information.}

\item{declaration}{should the declaration be imported}

\item{whitespace}{should whitespace pcdata be imported}

\item{empty_tags}{should \verb{<b/>} or \verb{<b></b>} be returned}

\item{skip_control}{should whitespace character be exported}
}
\description{
read xml file
}
\details{
Read xml files or strings to pointer and checks if the input is
valid XML.
If the input is read into a character object, it will be reevaluated every
time it is called. A pointer is evaluated once, but lives only for the
lifetime of the R session or once it is gc().
}
\examples{
  # a pointer
  x <- read_xml("<a><b/></a>")
  print(x)
  print(x, raw = TRUE)
  str(x)

  # a character
  y <- read_xml("<a><b/></a>", pointer = FALSE)
  print(y)
  print(y, raw = TRUE)
  str(y)

  # Errors if the import was unsuccessful
  try(z <- read_xml("<a><b/>"))

  xml <- '<?xml test="yay" ?><a>A & B</a>'
  # difference in escapes
  read_xml(xml, escapes = TRUE, pointer = FALSE)
  read_xml(xml, escapes = FALSE, pointer = FALSE)
  read_xml(xml, escapes = TRUE)
  read_xml(xml, escapes = FALSE)

  # read declaration
  read_xml(xml, declaration = TRUE)

}
