% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-workbook-wrappers.R
\name{wb_save}
\alias{wb_save}
\title{Save a workbook to file}
\usage{
wb_save(wb, file = NULL, overwrite = TRUE, path = NULL, flush = FALSE)
}
\arguments{
\item{wb}{A \code{wbWorkbook} object to write to file}

\item{file}{A path to save the workbook to}

\item{overwrite}{If \code{FALSE}, will not overwrite when \code{file} already exists.}

\item{path}{Deprecated argument. Please use \code{file} in new code.}

\item{flush}{Experimental, streams the worksheet file to disk}
}
\value{
the \code{wbWorkbook} object, invisibly
}
\description{
Save a workbook to file
}
\details{
When saving a \code{wbWorkbook} to a file, memory usage may spike
depending on the worksheet size. This happens because the entire XML
structure is created in memory before writing to disk. The memory
required depends on worksheet size, as XML files consist of character
data and include additional overhead for validity checks.

The \code{flush} argument streams worksheet XML data directly to disk,
avoiding the need to build the full XML tree in memory. This reduces
memory usage but skips some XML validity checks. It also bypasses
the \code{pugixml} functions that \code{openxlsx2} uses, omitting certain
preliminary sanity checks before writing. As the name suggests,
the output is simply flushed to disk.
}
\examples{
## Create a new workbook and add a worksheet
wb <- wb_workbook("Creator of workbook")
wb$add_worksheet(sheet = "My first worksheet")

## Save workbook to working directory
\donttest{
wb_save(wb, file = temp_xlsx(), overwrite = TRUE)
}
}
\seealso{
Other workbook wrappers: 
\code{\link{base_font-wb}},
\code{\link{col_widths-wb}},
\code{\link{creators-wb}},
\code{\link{grouping-wb}},
\code{\link{row_heights-wb}},
\code{\link{wb_add_chartsheet}()},
\code{\link{wb_add_data}()},
\code{\link{wb_add_data_table}()},
\code{\link{wb_add_formula}()},
\code{\link{wb_add_hyperlink}()},
\code{\link{wb_add_pivot_table}()},
\code{\link{wb_add_slicer}()},
\code{\link{wb_add_worksheet}()},
\code{\link{wb_base_colors}},
\code{\link{wb_clone_worksheet}()},
\code{\link{wb_copy_cells}()},
\code{\link{wb_freeze_pane}()},
\code{\link{wb_merge_cells}()},
\code{\link{wb_set_last_modified_by}()},
\code{\link{wb_workbook}()}
}
\concept{workbook wrappers}
