% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cert.R
\name{cert_verify}
\alias{cert_verify}
\alias{download_ssl_cert}
\alias{ca_bundle}
\title{X509 certificates}
\usage{
cert_verify(cert, root = ca_bundle())

download_ssl_cert(host = "localhost", port = 443)

ca_bundle()
}
\arguments{
\item{cert}{certificate (or certificate-chain) to be verified. Must be cert or list or path.}

\item{root}{trusted pubkey or certificate(s) e.g. CA bundle.}

\item{host}{string: hostname of the server to connect to}

\item{port}{string or integer: port or protocol to use, e.g: \code{443} or \code{"https"}}
}
\description{
Read, download, analyze and verify X.509 certificates.
}
\details{
If https verification fails and you can't figure out why, have a look
at \url{https://ssldecoder.org}.
}
\examples{
# Verify the r-project HTTPS cert
chain <- download_ssl_cert("www.r-project.org", 443)
print(chain)
print(as.list(chain[[1]])$pubkey)
cert_verify(chain, ca_bundle())

# Another example
chain <- download_ssl_cert("public.opencpu.org")
ocpu <- chain[[1]]
as.list(ocpu)$subject

# Write PEM format
write_pem(ocpu)
}
\seealso{
\link{read_cert}
}
