% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-antibiotics.R
\docType{data}
\name{antibiotics}
\alias{antibiotics}
\alias{antibiotics.in.children}
\alias{antibiotics_in_children}
\title{Pre-existing conditions in 92 children}
\format{
A data frame with 92 observations, each representing a child, on the
following variable.
\describe{
\item{condition}{Pre-existing medical condition.}
}
}
\usage{
antibiotics
}
\description{
Pre-existing medical conditions of 92 children involved in a study on the
optimal duration of antibiotic use in treatment of tracheitis, which is an
upper respiratory infection.
}
\examples{

library(ggplot2)

ggplot(antibiotics, aes(x = condition)) +
  geom_bar() +
  labs(x = "Conidition", y = "Count",
       title = "Pre-existing coniditions of children",
       subtitle = "in antibiotic use study") +
  coord_flip()

}
\keyword{datasets}
