% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_resource.R
\name{get_resource}
\alias{get_resource}
\title{Download a resource into your R session}
\usage{
get_resource(resource)
}
\arguments{
\item{resource}{A way to identify the resource. Either a resource ID (passed as a character vector directly) or a single resource resulting from \code{\link{list_package_resources}}.}
}
\value{
In most cases, the resource is returned as a tibble or list of tibbles.
If it is a spatial resource (i.e. SHP or GeoJSON), it is returned as an sf object.
}
\description{
Download a resource from the portal directly into your R session. CSV, XLS, XLSX, XML, JSON, SHP, ZIP, and GeoJSON resources are supported.
}
\examples{
\donttest{
res <- list_package_resources("1db34737-ffad-489d-a590-9171d500d453")
get_resource(resource = res[1, "id"])
res[["id"]]
get_resource("b9214fd7-60d1-45f3-8463-a6bd9828f8bf")
}
}
