% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polar_freqMap.R
\name{freqMapStatic}
\alias{freqMapStatic}
\title{Polar frequency plots on a static ggmap}
\usage{
freqMapStatic(
  data,
  pollutant = NULL,
  ggmap,
  statistic = "mean",
  breaks = "free",
  latitude = NULL,
  longitude = NULL,
  facet = NULL,
  cols = "turbo",
  alpha = 1,
  key = FALSE,
  facet.nrow = NULL,
  d.icon = 150,
  d.fig = 3,
  ...
)
}
\arguments{
\item{data}{A data frame. The data frame must contain the data to plot the
directional analysis marker, which includes wind speed (\code{ws}), wind
direction (\code{wd}), and the column representing the concentration of a
pollutant. In addition, \code{data} must include a decimal latitude and
longitude.}

\item{pollutant}{The column name(s) of the pollutant(s) to plot. If multiple
pollutants are specified, they will each form part of a separate panel.}

\item{ggmap}{A \code{ggmap} object obtained using \code{\link[ggmap:get_map]{ggmap::get_map()}} or a similar
function to use as the basemap.}

\item{statistic}{The statistic that should be applied to each wind
speed/direction bin. Can be "frequency", "mean", "median", "max" (maximum),
"stdev" (standard deviation) or "weighted.mean". The option "frequency" is
the simplest and plots the frequency of wind speed/direction in different
bins. The scale therefore shows the counts in each bin. The option "mean"
(the default) will plot the mean concentration of a pollutant (see next
point) in wind speed/direction bins, and so on.  Finally, "weighted.mean"
will plot the concentration of a pollutant weighted by wind
speed/direction. Each segment therefore provides the percentage overall
contribution to the total concentration. Note that for options other than
"frequency", it is necessary to also provide the name of a pollutant. See
function \code{\link[openair:cutData]{openair::cutData()}} for further details.}

\item{breaks}{One of:
\itemize{
\item \code{"fixed"} which ensures all of the markers use the same colour scale.
\item \code{"free"} (the default) which allows all of the markers to use different
colour scales.
\item A numeric vector defining a sequence of numbers to use as the breaks. The
sequence could represent one with equal spacing, e.g., \code{breaks = seq(0, 100, 10)} - a scale from 0-10 in intervals of 10, or a more flexible
sequence, e.g., \code{breaks = c(0, 1, 5, 7, 10)}, which may be useful for some
situations.
}}

\item{latitude, longitude}{The decimal latitude/longitude. If not provided,
will be automatically inferred from data by looking for a column named
"lat"/"latitude" or "lon"/"lng"/"long"/"longitude" (case-insensitively).}

\item{facet}{Used for splitting the input data into different panels, passed
to the \code{type} argument of \code{\link[openair:cutData]{openair::cutData()}}. \code{facet} cannot be used if
multiple \code{pollutant} columns have been provided.}

\item{cols}{The colours used for plotting. See \code{\link[openair:openColours]{openair::openColours()}} for
more information.}

\item{alpha}{The alpha transparency to use for the plotting surface (a value
between 0 and 1 with zero being fully transparent and 1 fully opaque).}

\item{key}{Should a key for each marker be drawn? Default is \code{FALSE}.}

\item{facet.nrow}{Passed to the \code{nrow} argument of \code{\link[ggplot2:facet_wrap]{ggplot2::facet_wrap()}}.}

\item{d.icon}{The diameter of the plot on the map in pixels. This will affect
the size of the individual polar markers. Alternatively, a vector in the
form \code{c(width, height)} can be provided if a non-circular marker is
desired.}

\item{d.fig}{The diameter of the plots to be produced using \code{openair} in
inches. This will affect the resolution of the markers on the map.
Alternatively, a vector in the form \code{c(width, height)} can be provided if a
non-circular marker is desired.}

\item{...}{
  Arguments passed on to \code{\link[openair:polarFreq]{openair::polarFreq}}
  \describe{
    \item{\code{ws.int}}{Wind speed interval assumed. In some cases e.g. a low met
mast, an interval of 0.5 may be more appropriate.}
    \item{\code{wd.nint}}{Number of intervals of wind direction.}
    \item{\code{grid.line}}{Radial spacing of grid lines.}
    \item{\code{trans}}{Should a transformation be applied? Sometimes when producing
plots of this kind they can be dominated by a few high points. The default
therefore is \code{TRUE} and a square-root transform is applied. This
results in a non-linear scale and (usually) a better representation of the
distribution. If set to \code{FALSE} a linear scale is used.}
    \item{\code{type}}{\code{type} determines how the data are split i.e. conditioned,
and then plotted. The default is will produce a single plot using the
entire data. Type can be one of the built-in types as detailed in
\code{cutData} e.g. \dQuote{season}, \dQuote{year}, \dQuote{weekday} and so
on. For example, \code{type = "season"} will produce four plots --- one for
each season.

It is also possible to choose \code{type} as another variable in the data
frame. If that variable is numeric, then the data will be split into four
quantiles (if possible) and labelled accordingly. If type is an existing
character or factor variable, then those categories/levels will be used
directly. This offers great flexibility for understanding the variation of
different variables and how they depend on one another.

Type can be up length two e.g. \code{type = c("season", "weekday")} will
produce a 2x2 plot split by season and day of the week. Note, when two
types are provided the first forms the columns and the second the rows.}
    \item{\code{min.bin}}{The minimum number of points allowed in a wind speed/wind
direction bin.  The default is 1. A value of two requires at least 2 valid
records in each bin an so on; bins with less than 2 valid records are set
to NA. Care should be taken when using a value > 1 because of the risk of
removing real data points. It is recommended to consider your data with
care. Also, the \code{polarFreq} function can be of use in such
circumstances.}
    \item{\code{ws.upper}}{A user-defined upper wind speed to use. This is useful for
ensuring a consistent scale between different plots. For example, to
always ensure that wind speeds are displayed between 1-10, set
\code{ws.int = 10}.}
    \item{\code{offset}}{\code{offset} controls the size of the \sQuote{hole} in the
middle and is expressed as a percentage of the maximum wind speed. Setting
a higher \code{offset} e.g. 50 is useful for \code{statistic =
  "weighted.mean"} when \code{ws.int} is greater than the maximum wind
speed. See example below.}
    \item{\code{border.col}}{The colour of the boundary of each wind speed/direction
bin. The default is transparent. Another useful choice sometimes is
"white".}
    \item{\code{key.header}}{Adds additional text/labels to the scale key. For example,
passing the options \code{key.header = "header", key.footer = "footer1"}
adds addition text above and below the scale key. These arguments are
passed to \code{drawOpenKey} via \code{quickText}, applying the
\code{auto.text} argument, to handle formatting.}
    \item{\code{key.footer}}{see \code{key.footer}.}
    \item{\code{key.position}}{Location where the scale key is to plotted. Allowed
arguments currently include \code{"top"}, \code{"right"}, \code{"bottom"}
and \code{"left"}.}
    \item{\code{auto.text}}{Either \code{TRUE} (default) or \code{FALSE}. If \code{TRUE}
titles and axis labels will automatically try and format pollutant names
and units properly e.g.  by subscripting the `2' in NO2.}
  }}
}
\value{
a \code{ggplot2} plot with a \code{ggmap} basemap
}
\description{
\code{\link[=freqMapStatic]{freqMapStatic()}} creates a \code{ggplot2} map using polar frequency plots as
markers. As this function returns a \code{ggplot2} object, further customisation
can be achieved using functions like \code{\link[ggplot2:theme]{ggplot2::theme()}} and
\code{\link[ggplot2:guides]{ggplot2::guides()}}.
}
\section{Further customisation using ggplot2}{


As the outputs of the static directional analysis functions are \code{ggplot2}
figures, further customisation is possible using functions such as
\code{\link[ggplot2:theme]{ggplot2::theme()}}, \code{\link[ggplot2:guides]{ggplot2::guides()}} and \code{\link[ggplot2:labs]{ggplot2::labs()}}.

If multiple pollutants are specified, subscripting (e.g., the "x" in "NOx")
is achieved using the \link[ggtext:ggtext]{ggtext} package. Therefore if you
choose to override the plot theme, it is recommended to use
\verb{[ggplot2::theme()]} and \verb{[ggtext::element_markdown()]} to define the
\code{strip.text} parameter.

When arguments like \code{limits}, \code{percentile} or \code{breaks} are defined, a
legend is automatically added to the figure. Legends can be removed using
\code{ggplot2::theme(legend.position = "none")}, or further customised using
\code{\link[ggplot2:guides]{ggplot2::guides()}} and either \code{color = ggplot2::guide_colourbar()} for
continuous legends or \code{fill = ggplot2::guide_legend()} for discrete
legends.
}

\seealso{
the original \code{\link[openair:polarFreq]{openair::polarFreq()}}

\code{\link[=freqMap]{freqMap()}} for the interactive \code{leaflet} equivalent of
\code{\link[=freqMapStatic]{freqMapStatic()}}

Other static directional analysis maps: 
\code{\link{annulusMapStatic}()},
\code{\link{diffMapStatic}()},
\code{\link{percentileMapStatic}()},
\code{\link{polarMapStatic}()},
\code{\link{pollroseMapStatic}()},
\code{\link{windroseMapStatic}()}
}
\concept{static directional analysis maps}
