% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polar_windroseMap.R
\name{windroseMapStatic}
\alias{windroseMapStatic}
\title{Wind rose plots on a static ggmap}
\usage{
windroseMapStatic(
  data,
  ws.int = 2,
  breaks = 4,
  facet = NULL,
  latitude = NULL,
  longitude = NULL,
  zoom = 13,
  ggmap = NULL,
  cols = "turbo",
  alpha = 1,
  key = FALSE,
  facet.nrow = NULL,
  d.icon = 150,
  d.fig = 3,
  ...
)
}
\arguments{
\item{data}{A data frame. The data frame must contain the data to plot the
directional analysis marker, which includes wind speed (\code{ws}), wind
direction (\code{wd}), and the column representing the concentration of a
pollutant. In addition, \code{data} must include a decimal latitude and
longitude.}

\item{ws.int}{The wind speed interval. Default is 2 m/s but for low met masts
with low mean wind speeds a value of 1 or 0.5 m/s may be better.}

\item{breaks}{Most commonly, the number of break points for wind speed in
windRose. For windRose and the ws.int default of 2 m/s, the default, 4,
generates the break points 2, 4, 6, 8 m/s. Breaks can also be used to set
specific break points. For example, the argument breaks = c(0, 1, 10, 100)
breaks the data into segments <1, 1-10, 10-100, >100.}

\item{facet}{Column to be used for splitting the input data into different
panels. Appropriate columns could be those added by \code{\link[openair:cutData]{openair::cutData()}} or
\code{\link[openair:splitByDate]{openair::splitByDate()}}. \code{facet} cannot be used if multiple \code{pollutant}
columns have been provided.}

\item{latitude, longitude}{The decimal latitude/longitude. If not provided,
will be automatically inferred from data by looking for a column named
"lat"/"latitude" or "lon"/"lng"/"long"/"longitude" (case-insensitively).}

\item{zoom}{The zoom level to use for the basemap, passed to
\code{\link[ggmap:get_stamenmap]{ggmap::get_stamenmap()}}. Alternatively, the \code{ggmap} argument can be used
for more precise control of the basemap.}

\item{ggmap}{By default, \code{openairmaps} will try to estimate an appropriate
bounding box for the input data and then run \code{\link[ggmap:get_stamenmap]{ggmap::get_stamenmap()}} to
import a basemap. The \code{ggmap} argument allows users to provide their own
\code{ggmap} object to override this, which allows for alternative bounding
boxes, map types and colours.}

\item{cols}{The colours used for plotting. See \code{\link[openair:openColours]{openair::openColours()}} for
more information.}

\item{alpha}{The alpha transparency to use for the plotting surface (a value
between 0 and 1 with zero being fully transparent and 1 fully opaque).}

\item{key}{Should a key for each marker be drawn? Default is \code{FALSE}.}

\item{facet.nrow}{Passed to the \code{nrow} argument of \code{\link[ggplot2:facet_wrap]{ggplot2::facet_wrap()}}.}

\item{d.icon}{The diameter of the plot on the map in pixels. This will affect
the size of the individual polar markers. Alternatively, a vector in the
form \code{c(width, height)} can be provided if a non-circular marker is
desired.}

\item{d.fig}{The diameter of the plots to be produced using \code{openair} in
inches. This will affect the resolution of the markers on the map.
Alternatively, a vector in the form \code{c(width, height)} can be provided if a
non-circular marker is desired.}

\item{...}{
  Arguments passed on to \code{\link[openair:polarAnnulus]{openair::polarAnnulus}}
  \describe{
    \item{\code{resolution}}{Two plot resolutions can be set: \dQuote{normal} and
\dQuote{fine} (the default).}
    \item{\code{local.tz}}{Should the results be calculated in local time that includes
a treatment of daylight savings time (DST)? The default is not to consider
DST issues, provided the data were imported without a DST offset. Emissions
activity tends to occur at local time e.g. rush hour is at 8 am every day.
When the clocks go forward in spring, the emissions are effectively
released into the atmosphere typically 1 hour earlier during the summertime
i.e. when DST applies. When plotting diurnal profiles, this has the effect
of \dQuote{smearing-out} the concentrations. Sometimes, a useful approach
is to express time as local time. This correction tends to produce
better-defined diurnal profiles of concentration (or other variables) and
allows a better comparison to be made with emissions/activity data. If set
to \code{FALSE} then GMT is used. Examples of usage include \code{local.tz
  = "Europe/London"}, \code{local.tz = "America/New_York"}. See
\code{cutData} and \code{import} for more details.}
    \item{\code{type}}{\code{type} determines how the data are split i.e. conditioned,
and then plotted. The default is will produce a single plot using the
entire data. Type can be one of the built-in types as detailed in
\code{cutData} e.g. \dQuote{season}, \dQuote{year}, \dQuote{weekday} and so
on. For example, \code{type = "season"} will produce four plots --- one for
each season.

It is also possible to choose \code{type} as another variable in the data
frame. If that variable is numeric, then the data will be split into four
quantiles (if possible) and labelled accordingly. If type is an existing
character or factor variable, then those categories/levels will be used
directly. This offers great flexibility for understanding the variation of
different variables and how they depend on one another.

Type can be up length two e.g. \code{type = c("season", "site")} will
produce a 2x2 plot split by season and site. The use of two types is mostly
meant for situations where there are several sites. Note, when two types
are provided the first forms the columns and the second the rows.

Also note that for the \code{polarAnnulus} function some type/period
combinations are forbidden or make little sense. For example, \code{type =
  "season"} and \code{period = "trend"} (which would result in a plot with
too many gaps in it for sensible smoothing), or \code{type = "weekday"} and
\code{period = "weekday"}.}
    \item{\code{statistic}}{The statistic that should be applied to each wind
speed/direction bin. Can be \dQuote{mean} (default), \dQuote{median},
\dQuote{max} (maximum), \dQuote{frequency}. \dQuote{stdev} (standard
deviation), \dQuote{weighted.mean} or \dQuote{cpf} (Conditional Probability
Function). Because of the smoothing involved, the colour scale for some of
these statistics is only to provide an indication of overall pattern and
should not be interpreted in concentration units e.g. for \code{statistic =
  "weighted.mean"} where the bin mean is multiplied by the bin frequency and
divided by the total frequency. In many cases using \code{polarFreq} will
be better. Setting \code{statistic = "weighted.mean"} can be useful because
it provides an indication of the concentration * frequency of occurrence
and will highlight the wind speed/direction conditions that dominate the
overall mean.}
    \item{\code{percentile}}{If \code{statistic = "percentile"} or \code{statistic =
  "cpf"} then \code{percentile} is used, expressed from 0 to 100. Note that
the percentile value is calculated in the wind speed, wind direction
\sQuote{bins}. For this reason it can also be useful to set \code{min.bin}
to ensure there are a sufficient number of points available to estimate a
percentile. See \code{quantile} for more details of how percentiles are
calculated.}
    \item{\code{width}}{The width of the annulus; can be \dQuote{normal} (the default),
\dQuote{thin} or \dQuote{fat}.}
    \item{\code{min.bin}}{The minimum number of points allowed in a wind speed/wind
direction bin.  The default is 1. A value of two requires at least 2 valid
records in each bin an so on; bins with less than 2 valid records are set
to NA. Care should be taken when using a value > 1 because of the risk of
removing real data points. It is recommended to consider your data with
care. Also, the \code{polarFreq} function can be of use in such
circumstances.}
    \item{\code{exclude.missing}}{Setting this option to \code{TRUE} (the default)
removes points from the plot that are too far from the original data. The
smoothing routines will produce predictions at points where no data exist
i.e. they predict. By removing the points too far from the original data
produces a plot where it is clear where the original data lie. If set to
\code{FALSE} missing data will be interpolated.}
    \item{\code{date.pad}}{For \code{type = "trend"} (default), \code{date.pad = TRUE}
will pad-out missing data to the beginning of the first year and the end of
the last year. The purpose is to ensure that the trend plot begins and ends
at the beginning or end of year.}
    \item{\code{force.positive}}{The default is \code{TRUE}. Sometimes if smoothing data
with steep gradients it is possible for predicted values to be negative.
\code{force.positive = TRUE} ensures that predictions remain positive. This
is useful for several reasons. First, with lots of missing data more
interpolation is needed and this can result in artefacts because the
predictions are too far from the original data. Second, if it is known
beforehand that the data are all positive, then this option carries that
assumption through to the prediction. The only likely time where setting
\code{force.positive = FALSE} would be if background concentrations were
first subtracted resulting in data that is legitimately negative. For the
vast majority of situations it is expected that the user will not need to
alter the default option.}
    \item{\code{k}}{The smoothing value supplied to \code{gam} for the temporal and wind
direction components, respectively. In some cases e.g. a trend plot with
less than 1-year of data the smoothing with the default values may become
too noisy and affected more by outliers. Choosing a lower value of \code{k}
(say 10) may help produce a better plot.}
    \item{\code{normalise}}{If \code{TRUE} concentrations are normalised by dividing by
their mean value. This is done \emph{after} fitting the smooth surface.
This option is particularly useful if one is interested in the patterns of
concentrations for several pollutants on different scales e.g. NOx and CO.
Often useful if more than one \code{pollutant} is chosen.}
    \item{\code{key.header}}{Adds additional text/labels to the scale key. For example,
passing the options \code{key.header = "header", key.footer = "footer1"}
adds addition text above and below the scale key. These arguments are
passed to \code{drawOpenKey} via \code{quickText}, applying the
\code{auto.text} argument, to handle formatting.}
    \item{\code{key.footer}}{see \code{key.footer}.}
    \item{\code{key.position}}{Location where the scale key is to plotted. Allowed
arguments currently include \code{"top"}, \code{"right"}, \code{"bottom"}
and \code{"left"}.}
    \item{\code{auto.text}}{Either \code{TRUE} (default) or \code{FALSE}. If \code{TRUE}
titles and axis labels will automatically try and format pollutant names
and units properly e.g.  by subscripting the `2' in NO2.}
  }}
}
\value{
a \code{ggplot2} plot with a \code{ggmap} basemap
}
\description{
\code{\link[=windroseMapStatic]{windroseMapStatic()}} creates a \code{ggplot2} map using wind roses as markers. As
this function returns a \code{ggplot2} object, further customisation can be
achieved using functions like \code{\link[ggplot2:theme]{ggplot2::theme()}} and \code{\link[ggplot2:guides]{ggplot2::guides()}}. See
\code{\link[openair:polarPlot]{openair::polarPlot()}} for more information.
}
\section{Further customisation using ggplot2}{


As the outputs of the static directional analysis functions are \code{ggplot2}
figures, further customisation is possible using functions such as
\code{\link[ggplot2:theme]{ggplot2::theme()}}, \code{\link[ggplot2:guides]{ggplot2::guides()}} and \code{\link[ggplot2:labs]{ggplot2::labs()}}.

If multiple pollutants are specified, subscripting (e.g., the "x" in "NOx")
is achieved using the \link[ggtext:ggtext]{ggtext} package. Therefore if you
choose to override the plot theme, it is recommended to use
\verb{[ggplot2::theme()]} and \verb{[ggtext::element_markdown()]} to define the
\code{strip.text} parameter.

When arguments like \code{limits}, \code{percentile} or \code{breaks} are defined, a
legend is automatically added to the figure. Legends can be removed using
\code{ggplot2::theme(legend.position = "none")}, or further customised using
\code{\link[ggplot2:guides]{ggplot2::guides()}} and either \code{color = ggplot2::guide_colourbar()} for
continuous legends or \code{fill = ggplot2::guide_legend()} for discrete
legends.
}

\seealso{
the original \code{\link[openair:windRose]{openair::windRose()}}

\code{\link[=windroseMap]{windroseMap()}} for the interactive \code{leaflet} equivalent of
\code{\link[=windroseMapStatic]{windroseMapStatic()}}

Other static directional analysis maps: 
\code{\link{annulusMapStatic}()},
\code{\link{diffMapStatic}()},
\code{\link{freqMapStatic}()},
\code{\link{percentileMapStatic}()},
\code{\link{polarMapStatic}()},
\code{\link{pollroseMapStatic}()}
}
\concept{static directional analysis maps}
