% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pollroseMap.R
\name{pollroseMap}
\alias{pollroseMap}
\title{Pollution rose plots on interactive leaflet maps}
\usage{
pollroseMap(
  data,
  pollutant = NULL,
  statistic = "prop.count",
  breaks = NULL,
  latitude = NULL,
  longitude = NULL,
  control = NULL,
  popup = NULL,
  label = NULL,
  provider = "OpenStreetMap",
  cols = "turbo",
  key = FALSE,
  draw.legend = TRUE,
  collapse.control = FALSE,
  iconWidth = 200,
  iconHeight = 200,
  fig.width = 3.5,
  fig.height = 3.5,
  type = NULL,
  ...
)
}
\arguments{
\item{data}{A data frame. The data frame must contain the data to plot the
directional analysis marker, which includes wind speed (\code{ws}), wind
direction (\code{wd}), and the column representing the concentration of a
pollutant. In addition, \code{data} must include a decimal latitude and
longitude.}

\item{pollutant}{The column name(s) of the pollutant(s) to plot. If multiple
pollutants are specified, they can be toggled between using a "layer
control" interface.}

\item{statistic}{The \code{statistic} to be applied to each data bin in the
plot. Options currently include "prop.count", "prop.mean" and
"abs.count". The default "prop.count" sizes bins according to
the proportion of the frequency of measurements.  Similarly,
"prop.mean" sizes bins according to their relative contribution to
the mean. "abs.count" provides the absolute count of measurements in
each bin.}

\item{breaks}{Most commonly, the number of break points. If not specified,
each marker will independently break its supplied data at approximately 6
sensible break points. When \code{breaks} are specified, all markers will
use the same break points. Breaks can also be used to set specific break
points. For example, the argument \code{breaks = c(0, 1, 10, 100)} breaks
the data into segments <1, 1-10, 10-100, >100.}

\item{latitude, longitude}{The decimal latitude/longitude. If not provided,
will be automatically inferred from data by looking for a column named
"lat"/"latitude" or
"lon"/"lng"/"long"/"longitude"
(case-insensitively).}

\item{control}{Column to be used for splitting the input data into different
groups which can be selected between using a "layer control" interface.
Appropriate columns could be those added by \code{\link[openair:cutData]{openair::cutData()}} or
\code{\link[openair:splitByDate]{openair::splitByDate()}}. \code{control} cannot be used if multiple
\code{pollutant} columns have been provided.}

\item{popup}{Column to be used as the HTML content for marker popups. Popups
may be useful to show information about the individual sites (e.g., site
names, codes, types, etc.).}

\item{label}{Column to be used as the HTML content for hover-over labels.
Labels are useful for the same reasons as popups, though are typically
shorter.}

\item{provider}{The base map(s) to be used. See
\url{http://leaflet-extras.github.io/leaflet-providers/preview/} for a list
of all base maps that can be used. If multiple base maps are provided, they
can be toggled between using a "layer control" interface.}

\item{cols}{The colours used for plotting.}

\item{key}{Should a key for each marker be drawn? Default is \code{FALSE}.}

\item{draw.legend}{When \code{breaks} are specified, should a shared legend
be created at the side of the map? Default is \code{TRUE}.}

\item{collapse.control}{Should the "layer control" interface be collapsed?
Defaults to \code{FALSE}.}

\item{iconWidth}{The actual width of the plot on the map in pixels.}

\item{iconHeight}{The actual height of the plot on the map in pixels.}

\item{fig.width}{The width of the plots to be produced in inches.}

\item{fig.height}{The height of the plots to be produced in inches.}

\item{type}{Deprecated. Please use \code{label} and/or \code{popup} to label
different sites.}

\item{...}{
  Arguments passed on to \code{\link[openair:pollutionRose]{openair::pollutionRose}}
  \describe{
    \item{\code{key.footer}}{Adds additional text/labels below the scale key. See
\code{key.header} for further information.}
    \item{\code{key.position}}{Location where the scale key is to plotted. Allowed
arguments currently include \dQuote{top}, \dQuote{right}, \dQuote{bottom}
and \dQuote{left}.}
    \item{\code{paddle}}{Either \code{TRUE} or \code{FALSE}. If \code{TRUE} plots rose
using 'paddle' style spokes. If \code{FALSE} plots rose using 'wedge' style
spokes.}
    \item{\code{seg}}{When \code{paddle = TRUE}, \code{seg} determines with width of the
segments. For example, \code{seg = 0.5} will produce segments 0.5 *
\code{angle}.}
    \item{\code{normalise}}{If \code{TRUE} each wind direction segment is normalised to
equal one. This is useful for showing how the concentrations (or other
parameters) contribute to each wind sector when the proportion of time the
wind is from that direction is low. A line showing the probability that the
wind directions is from a particular wind sector is also shown.}
  }}
}
\value{
A leaflet object.
}
\description{
\code{\link[=pollroseMap]{pollroseMap()}} creates a \code{leaflet} map using "pollution roses" as
markers. Any number of pollutants can be specified using the \code{pollutant}
argument, and multiple layers of markers can be added and toggled between
using \code{control}. See \code{\link[openair:pollutionRose]{openair::pollutionRose()}} for more information.
}
\examples{
\dontrun{
pollroseMap(polar_data,
  pollutant = "nox",
  statistic = "prop.count",
  provider = "Stamen.Toner"
)
}
}
\seealso{
Other directional analysis maps: 
\code{\link{annulusMap}()},
\code{\link{freqMap}()},
\code{\link{percentileMap}()},
\code{\link{polarMap}()},
\code{\link{windroseMap}()}
}
\concept{directional analysis maps}
