/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.coref.mention;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import opennlp.tools.coref.mention.HeadFinder;
import opennlp.tools.coref.mention.Parse;

public final class PTBHeadFinder
implements HeadFinder {
    private static PTBHeadFinder instance;
    private static Set<String> skipSet;

    private PTBHeadFinder() {
    }

    public static HeadFinder getInstance() {
        if (instance == null) {
            instance = new PTBHeadFinder();
        }
        return instance;
    }

    public Parse getHead(Parse p) {
        if (p == null) {
            return null;
        }
        if (p.isNounPhrase()) {
            Parse child;
            Parse child0;
            List<Parse> parts = p.getSyntacticChildren();
            if (parts.size() > 2) {
                child0 = parts.get(0);
                Parse child1 = parts.get(1);
                Parse child2 = parts.get(2);
                if (child1.isToken() && child1.getSyntacticType().equals("POS") && child0.isNounPhrase() && child2.isNounPhrase()) {
                    return child2;
                }
            }
            if (parts.size() > 1 && (child0 = parts.get(0)).isNounPhrase()) {
                Parse tok;
                List<Parse> ctoks = child0.getTokens();
                if (ctoks.size() == 0) {
                    System.err.println("PTBHeadFinder: NP " + child0 + " with no tokens");
                }
                if ((tok = ctoks.get(ctoks.size() - 1)).getSyntacticType().equals("POS")) {
                    return null;
                }
            }
            if (parts.size() > 1) {
                for (int pi = 1; pi < parts.size() - 1; ++pi) {
                    child = parts.get(pi);
                    if (!child.isToken() || !child.getSyntacticType().equals("CC")) continue;
                    return null;
                }
            }
            for (int pi = 0; pi < parts.size(); ++pi) {
                child = parts.get(pi);
                if (!child.isNounPhrase()) continue;
                return child;
            }
            return null;
        }
        return null;
    }

    public int getHeadIndex(Parse p) {
        List<Parse> sChildren = p.getSyntacticChildren();
        boolean countTokens = false;
        int tokenCount = 0;
        int scn = sChildren.size();
        for (int sci = 0; sci < scn; ++sci) {
            Parse sc = sChildren.get(sci);
            if (sc.getSyntacticType().startsWith("S") && sci != 0) {
                countTokens = true;
            }
            if (!countTokens) continue;
            tokenCount += sc.getTokens().size();
        }
        List<Parse> toks = p.getTokens();
        if (toks.size() == 0) {
            System.err.println("PTBHeadFinder.getHeadIndex(): empty tok list for parse " + p);
        }
        for (int ti = toks.size() - tokenCount - 1; ti >= 0; --ti) {
            Parse tok = toks.get(ti);
            if (skipSet.contains(tok.getSyntacticType())) continue;
            return ti;
        }
        return toks.size() - tokenCount - 1;
    }

    public Parse getLastHead(Parse p) {
        Parse head;
        while (null != (head = this.getHead(p))) {
            p = head;
        }
        return p;
    }

    public Parse getHeadToken(Parse p) {
        List<Parse> toks = p.getTokens();
        return toks.get(this.getHeadIndex(p));
    }

    static {
        skipSet = new HashSet<String>();
        skipSet.add("POS");
        skipSet.add(",");
        skipSet.add(":");
        skipSet.add(".");
        skipSet.add("''");
        skipSet.add("-RRB-");
        skipSet.add("-RCB-");
    }
}

