/*
 * Decompiled with CFR 0.152.
 */
package opennlp.maxent;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.DecimalFormat;
import opennlp.maxent.Context;
import opennlp.maxent.EvalParameters;
import opennlp.maxent.MaxentModel;
import opennlp.maxent.Prior;
import opennlp.maxent.TObjectIndexHashMap;
import opennlp.maxent.UniformPrior;
import opennlp.maxent.io.SuffixSensitiveGISModelReader;

public final class GISModel
implements MaxentModel {
    private final TObjectIndexHashMap pmap;
    private final String[] ocNames;
    private DecimalFormat df;
    private EvalParameters evalParams;
    private Prior prior;

    public GISModel(Context[] params, String[] predLabels, String[] outcomeNames, int correctionConstant, double correctionParam) {
        this(params, predLabels, outcomeNames, correctionConstant, correctionParam, new UniformPrior());
    }

    public GISModel(Context[] params, String[] predLabels, String[] outcomeNames, int correctionConstant, double correctionParam, Prior prior) {
        this.pmap = new TObjectIndexHashMap(predLabels.length);
        int i = 0;
        while (i < predLabels.length) {
            this.pmap.put(predLabels[i], i);
            ++i;
        }
        this.ocNames = outcomeNames;
        this.evalParams = new EvalParameters(params, correctionParam, correctionConstant, this.ocNames.length);
        this.prior = prior;
        prior.setLabels(this.ocNames, predLabels);
    }

    public final double[] eval(String[] context) {
        return this.eval(context, new double[this.evalParams.numOutcomes]);
    }

    public final double[] eval(String[] context, float[] values) {
        return this.eval(context, values, new double[this.evalParams.numOutcomes]);
    }

    public static double[] eval(int[] context, double[] prior, EvalParameters model) {
        return GISModel.eval(context, null, prior, model);
    }

    public static double[] eval(int[] context, float[] values, double[] prior, EvalParameters model) {
        Context[] params = model.params;
        int[] numfeats = new int[model.numOutcomes];
        double value = 1.0;
        int ci = 0;
        while (ci < context.length) {
            if (context[ci] >= 0) {
                Context predParams = params[context[ci]];
                int[] activeOutcomes = predParams.getOutcomes();
                double[] activeParameters = predParams.getParameters();
                if (values != null) {
                    value = values[ci];
                }
                int ai = 0;
                while (ai < activeOutcomes.length) {
                    int oid;
                    int n = oid = activeOutcomes[ai];
                    numfeats[n] = numfeats[n] + 1;
                    int n2 = oid;
                    prior[n2] = prior[n2] + activeParameters[ai] * value;
                    ++ai;
                }
            }
            ++ci;
        }
        double normal = 0.0;
        int oid = 0;
        while (oid < model.numOutcomes) {
            prior[oid] = model.correctionParam != 0.0 ? Math.exp(prior[oid] * model.constantInverse + (1.0 - (double)numfeats[oid] / model.correctionConstant) * model.correctionParam) : Math.exp(prior[oid] * model.constantInverse);
            normal += prior[oid];
            ++oid;
        }
        oid = 0;
        while (oid < model.numOutcomes) {
            int n = oid++;
            prior[n] = prior[n] / normal;
        }
        return prior;
    }

    public final double[] eval(String[] context, double[] outsums) {
        return this.eval(context, null, outsums);
    }

    public final double[] eval(String[] context, float[] values, double[] outsums) {
        int[] scontexts = new int[context.length];
        int i = 0;
        while (i < context.length) {
            scontexts[i] = this.pmap.get(context[i]);
            ++i;
        }
        this.prior.logPrior(outsums, scontexts, values);
        return GISModel.eval(scontexts, values, outsums, this.evalParams);
    }

    public final String getBestOutcome(double[] ocs) {
        int best = 0;
        int i = 1;
        while (i < ocs.length) {
            if (ocs[i] > ocs[best]) {
                best = i;
            }
            ++i;
        }
        return this.ocNames[best];
    }

    public final String getAllOutcomes(double[] ocs) {
        if (ocs.length != this.ocNames.length) {
            return "The double array sent as a parameter to GISModel.getAllOutcomes() must not have been produced by this model.";
        }
        if (this.df == null) {
            this.df = new DecimalFormat("0.0000");
        }
        StringBuffer sb = new StringBuffer(ocs.length * 2);
        sb.append(this.ocNames[0]).append("[").append(this.df.format(ocs[0])).append("]");
        int i = 1;
        while (i < ocs.length) {
            sb.append("  ").append(this.ocNames[i]).append("[").append(this.df.format(ocs[i])).append("]");
            ++i;
        }
        return sb.toString();
    }

    public final String getOutcome(int i) {
        return this.ocNames[i];
    }

    public int getIndex(String outcome) {
        int i = 0;
        while (i < this.ocNames.length) {
            if (this.ocNames[i].equals(outcome)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int getNumOutcomes() {
        return this.evalParams.numOutcomes;
    }

    public final Object[] getDataStructures() {
        Object[] data = new Object[]{this.evalParams.params, this.pmap, this.ocNames, new Integer((int)this.evalParams.correctionConstant), new Double(this.evalParams.correctionParam)};
        return data;
    }

    public static void main(String[] args) throws IOException {
        if (args.length == 0) {
            System.err.println("Usage: GISModel modelname < contexts");
            System.exit(1);
        }
        GISModel m = new SuffixSensitiveGISModelReader(new File(args[0])).getModel();
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        DecimalFormat df = new DecimalFormat(".###");
        String line = in.readLine();
        while (line != null) {
            String[] context = line.split(" ");
            double[] dist = m.eval(context);
            int oi = 0;
            while (oi < dist.length) {
                System.out.print("[" + m.getOutcome(oi) + " " + df.format(dist[oi]) + "] ");
                ++oi;
            }
            System.out.println();
            line = in.readLine();
        }
    }
}

