/*
 * Decompiled with CFR 0.152.
 */
package opennlp.maxent;

import java.util.Arrays;

public class ComparableEvent
implements Comparable {
    public int outcome;
    public int[] predIndexes;
    public int seen = 1;
    public float[] values;

    public ComparableEvent(int oc, int[] pids, float[] values) {
        this.outcome = oc;
        if (values == null) {
            Arrays.sort(pids);
        } else {
            this.sort(pids, values);
        }
        this.values = values;
        this.predIndexes = pids;
    }

    public ComparableEvent(int oc, int[] pids) {
        this(oc, pids, null);
    }

    public int compareTo(Object o) {
        ComparableEvent ce = (ComparableEvent)o;
        if (this.outcome < ce.outcome) {
            return -1;
        }
        if (this.outcome > ce.outcome) {
            return 1;
        }
        int smallerLength = this.predIndexes.length > ce.predIndexes.length ? ce.predIndexes.length : this.predIndexes.length;
        int i = 0;
        while (i < smallerLength) {
            if (this.predIndexes[i] < ce.predIndexes[i]) {
                return -1;
            }
            if (this.predIndexes[i] > ce.predIndexes[i]) {
                return 1;
            }
            if (this.values != null && ce.values != null) {
                if (this.values[i] < ce.values[i]) {
                    return -1;
                }
                if (this.values[i] > ce.values[i]) {
                    return 1;
                }
            } else if (this.values != null) {
                if (this.values[i] < 1.0f) {
                    return -1;
                }
                if (this.values[i] > 1.0f) {
                    return 1;
                }
            } else if (ce.values != null) {
                if (1.0f < ce.values[i]) {
                    return -1;
                }
                if (1.0f > ce.values[i]) {
                    return 1;
                }
            }
            ++i;
        }
        if (this.predIndexes.length < ce.predIndexes.length) {
            return -1;
        }
        if (this.predIndexes.length > ce.predIndexes.length) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        StringBuffer s = new StringBuffer().append(this.outcome).append(":");
        int i = 0;
        while (i < this.predIndexes.length) {
            s.append(" ").append(this.predIndexes[i]);
            if (this.values != null) {
                s.append("=").append(this.values[i]);
            }
            ++i;
        }
        return s.toString();
    }

    private void sort(int[] pids, float[] values) {
        int mi = 0;
        while (mi < pids.length) {
            int min = mi;
            int pi = mi + 1;
            while (pi < pids.length) {
                if (pids[min] > pids[pi]) {
                    min = pi;
                }
                ++pi;
            }
            int pid = pids[mi];
            pids[mi] = pids[min];
            pids[min] = pid;
            float val = values[mi];
            values[mi] = values[min];
            values[min] = val;
            ++mi;
        }
    }
}

