% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opal.table.R
\name{harmo.table_save}
\alias{harmo.table_save}
\title{Save a local tibble as a Opal table (deprecated)}
\usage{
harmo.table_save(
  opal,
  tibble,
  project,
  table,
  overwrite = TRUE,
  force = FALSE,
  identifiers = NULL,
  policy = "required",
  id.name = "id",
  type = "Participant"
)
}
\arguments{
\item{opal}{Opal connection object.}

\item{tibble}{The tibble object to be imported.}

\item{project}{Project name where the table will be located.}

\item{table}{Destination table name.}

\item{overwrite}{If the destination table already exists, it will be replaced (deleted and then
imported). Otherwise the table will be updated (data dictionaries merge may conflict). Default is TRUE.
See also \link{opal.table_truncate} function.}

\item{force}{If the destination already exists, stop with an informative message if this flag is FALSE (default).}

\item{identifiers}{Name of the identifiers mapping to use when assigning entities to Opal.}

\item{policy}{Identifiers policy: 'required' (each identifiers must be mapped prior importation (default)), 'ignore' (ignore unknown identifiers) and 'generate' (generate a system identifier for each unknown identifier).}

\item{id.name}{The name of the column representing the entity identifiers. Default is 'id'.}

\item{type}{Entity type (what the data are about). Default is 'Participant'}
}
\value{
An invisible logical indicating whether the destination table exists.
}
\description{
Deprecated: use \link{opal.table_save} instead.
}
\examples{
\dontrun{
o <- opal.login('administrator','password', url='https://opal-demo.obiba.org')
cqx <- opal.table_get(o, "CPTP", "Cag_coreqx")
# do some (meta)data transformations, then save in opal's database
opal.table_save(o, cqx, "CPTP", "Cag_coreqx", overwrite = TRUE, force = TRUE)
# or overwrite data only (keep original data dictionary)
opal.table_save(o, cqx, "CPTP", "Cag_coreqx", overwrite = 'values', force = TRUE)
opal.logout(o)
}
}
