% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{get_OWL}
\alias{get_OWL}
\title{Read ontology as \code{ontology_index} from OWL format file}
\usage{
get_OWL(file, class_xpath = "owl:Class[@rdf:about]", id = OWL_IDs,
  name = OWL_labels, parents = OWL_is_a, obsolete = OWL_obsolete,
  version_xpath = "owl:Ontology", remove_missing = FALSE, ...)
}
\arguments{
\item{file}{Name of OWL formatted file.}

\item{class_xpath}{XPath expression for selecting the nodes corresponding to terms in the ontology.}

\item{id}{Function for pulling term IDs out of a \code{nodeset} object.}

\item{name}{Function for pulling term labels out of a \code{nodeset} object.}

\item{parents}{Function for selecting term parent IDs from for each term in a \code{nodeset} object. Defaults to \code{\link{OWL_is_a}}.}

\item{obsolete}{Function for selecting indicator of obsolescence for each term.}

\item{version_xpath}{XPath expression for selecting node which contains version information.}

\item{remove_missing}{Logical value determining whether the parents in parent-child relationships in the ontology should be removed from the index. If there are parents which are missing, failure to remove them will lead to an error.}

\item{...}{Additional (named) arguments, each a function accepting a \code{nodeset} object as an argument and each returning an array of values corresponding to the terms of the ontology.}
}
\value{
\code{ontology_index} object.
}
\description{
Read ontology as \code{ontology_index} from OWL format file
}

