% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.list.R
\name{summary.data.list}
\alias{summary.data.list}
\title{Summary with checks of the data.list for appropriate form.}
\usage{
\method{summary}{data.list}(
  object,
  printit = TRUE,
  stopit = TRUE,
  nms = names(object),
  msgextra = "",
  ...
)
}
\arguments{
\item{object}{The object to be summarized and checked}

\item{printit}{A boolean deciding if check results tables are printed}

\item{stopit}{A boolean deciding if the function stop with an error if the check is not ok}

\item{nms}{A character vector. If given specifies the variables (vectors or matrices) in object to check}

\item{msgextra}{A character which is added in the printout of an (potential) error message}

\item{...}{Not used}
}
\value{
The tables generated.

Checking the data.list for appropriate form:

A check of the time vector t, which must have equidistant time points and no NAs.

Then the results of checks of vectors (observations):

  - NAs: Proportion of NAs

  - length: Same length as the 't' vector?

  - class: The class of the vector

Then the results of checking data.frames and matrices (forecasts):

  - maxHorizonNAs: The proportion of NAs for the horizon (i.e. column) with the highest proportion of NAs

  - meanNAs: The proportion of NAs of the entire matrix

  - nrow: Same length as the 't' vector?

  - colnames: Columns must be names 'kx', where 'x' is the horizon (e.g. k12 is 12-step horizon)

  - sameclass: Error if not all columns are the same class

  - class: Prints the class of the columns if they are all the same
}
\description{
Summary including checks of the data.list for appropriate form.
}
\details{
Prints on table form the result of the checks.
}
\examples{

summary(Dbuilding)

# Some NAs in k1 forecast
D <- Dbuilding
D$Ta$k1[1:1500] <- NA
summary(D)

# Vector with observations not same length as t throws error
D <- Dbuilding
D$heatload <- D$heatload[1:10]
try(summary(D))

# Forecasts wrong count
D <- Dbuilding
D$Ta <- D$Ta[1:10, ]
try(summary(D))

# Wrong column names
D <- Dbuilding
names(D$Ta)[4] <- "xk"
names(D$Ta)[2] <- "x2"
try(summary(D))

# No column names
D <- Dbuilding
names(D$Ta) <- NULL
try(summary(D))

# Don't stop or only print if stopped 
onlineforecast:::summary.data.list(D, stopit=FALSE)
try(onlineforecast:::summary.data.list(D, printit=FALSE))

# Only check for specified variables
# (e.g. do like this in model functions to check only variables used in model)
onlineforecast:::summary.data.list(D, nms=c("heatload","I"))

}
