% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_dataset_bins.R
\name{create_data_bins}
\alias{create_data_bins}
\title{New dataset based on bins}
\usage{
create_data_bins(input.obj, bins)
}
\arguments{
\item{input.obj}{an object of class \code{onemap}.}

\item{bins}{an object of class \code{onemap_bin}.}
}
\value{
An object of class \code{onemap}, i.e., a list with the following
components: \item{geno}{a matrix with integers indicating the genotypes
read for each marker. Each column contains data for a marker and each row
represents an individual.} \item{n.ind}{number of individuals.}
\item{n.mar}{number of markers.} \item{segr.type}{a vector with the
segregation type of each marker, as \code{strings}.} \item{segr.type.num}{a
vector with the segregation type of each marker, represented in a
simplified manner as integers, i.e. 1 corresponds to markers of type
\code{"A"}; 2 corresponds to markers of type \code{"B1.5"}; 3 corresponds
to markers of type \code{"B2.6"}; 4 corresponds to markers of type
\code{"B3.7"}; 5 corresponds to markers of type \code{"C.8"}; 6 corresponds
to markers of type \code{"D1"} and 7 corresponds to markers of type
\code{"D2"}. Markers for F2 intercrosses are coded as 1; all other crosses
are left as \code{NA}.} \item{input}{the name of the input file.}
\item{n.phe}{number of phenotypes.} \item{pheno}{a matrix with phenotypic
values. Each column contains data for a trait and each row represents an
individual.} \item{error}{matrix containing HMM emission probabilities}
}
\description{
Creates a new dataset based on \code{onemap_bin} object
}
\details{
Given a \code{onemap_bin} object,
creates a new data set where the redundant markers are
collapsed into bins and represented by the marker with the lower
amount of missing data among those on the bin.
}
\examples{

  data("onemap_example_f2")
  (bins<-find_bins(onemap_example_f2, exact=FALSE))
  onemap_bins <- create_data_bins(onemap_example_f2, bins)

}
\seealso{
\code{\link[onemap]{find_bins}}
}
\author{
Marcelo Mollinari, \email{mmollina@usp.br}
}
\keyword{bins}
\keyword{dimension}
\keyword{reduction}
