% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parmap.R
\name{parmap}
\alias{parmap}
\title{A parallelized version of map function}
\usage{
parmap(
  input.seq = NULL,
  cores = 3,
  overlap = 4,
  tol = 1e-04,
  avoid_link_errors = TRUE,
  export_diff = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{input.seq}{an object of class \code{sequence}.}

\item{cores}{an integer defining the number of cores to be used and also the
number of batches generated}

\item{overlap}{number of markers overlapping between batches}

\item{tol}{tolerance for the C routine, i.e., the value used to evaluate
convergence.}

\item{avoid_link_errors}{logical. If TRUE markers which do not reach the linkage
criteria are removed of the sequence and the distances are automatically reestimated.
If FALSE an error stops the algorithm it find these markers.}

\item{export_diff}{If TRUE also returns (in the first level of the list) the differences
in genetic distances between overlaped markers}

\item{verbose}{A logical, if TRUE its output progress status
information.}
}
\value{
An object of class \code{sequence}, which is a list containing the
following components: \item{seq.num}{a \code{vector} containing the
(ordered) indices of markers in the sequence, according to the input file.}
\item{seq.phases}{a \code{vector} with the linkage phases between markers
in the sequence, in corresponding positions. \code{-1} means that there are
no defined linkage phases.} \item{seq.rf}{a \code{vector} with the
recombination frequencies between markers in the sequence. \code{-1} means
that there are no estimated recombination frequencies.}
\item{seq.like}{log-likelihood of the corresponding linkage map.}
\item{data.name}{name of the object of class \code{onemap} with the raw
data.} \item{twopt}{name of the object of class \code{rf_2pts} with the
2-point analyses.}
}
\description{
Based on the strategy propoused by Schiffthaler et al. the markers of a
linkage group with pre-defined order are divided in user defined batches 
with overlap markers between them. Each batch runs in a different core
which increase the speed of the genetic distances estimation. The distances 
and phases of the previous batch are considered to joint the batches. Also, 
it is possible to store the differences between the genetic distances 
between the overlaped markers as a measure of the process quality. In 
other words, if these differences are to too high, you can considered that
divide the group in batch did not compromise the distance estimation.
}
\references{
Schiffthaler, B., Bernhardsson, C., Ingvarsson, P. K., & Street, 
N. R. (2017). BatchMap: A parallel implementation of the OneMap R package 
for fast computation of F1 linkage maps in outcrossing species. PLoS ONE, 
12(12), 1–12. https://doi.org/10.1371/journal.pone.0189256
}
\seealso{
\code{\link[onemap]{map}}
}
\author{
Cristiane Taniguti \email{chtaniguti@tamu.edu}
}
