% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw_map2.R
\name{draw_map2}
\alias{draw_map2}
\title{Draw a linkage map}
\usage{
draw_map2(..., tag = NULL, id = TRUE, pos = TRUE, cex.label = NULL,
  main = NULL, group.names = NULL, centered = F, y.axis = TRUE,
  space = NULL, col.group = NULL, col.mark = NULL, col.tag = NULL,
  output = NULL)
}
\arguments{
\item{...}{sequence(s). Object(s) of class \code{sequence} with a predefined order, linkage phase, recombination fraction and likelihood. Can be used list(s) of sequences.}

\item{tag}{name(s) of the marker(s) to highlight. If "all", all markers will be highlighted. Default is \code{NULL}.}

\item{id}{logical. If \code{TRUE} (default), shows name(s) of tagged marker(s).}

\item{pos}{logical. If \code{TRUE} (default), shows position(s) of tagged marker(s).}

\item{cex.label}{the magnification used for label(s) of tagged marker(s). If \code{NULL} (default), the cex will be automatically calculated to avoid overlapping.}

\item{main}{an overall title for the plot. Default is \code{NULL}.}

\item{group.names}{name(s) to identfy the group(s). If \code{NULL} (default), the name(s) of the sequence(s) will be used.}

\item{centered}{logical. If \code{TRUE}, the group(s) will be aligned in the center. If \code{FALSE} (default), the group(s) will be aligned at the top.}

\item{y.axis}{logical. If \code{TRUE} (default), shows y axis. If centered = \code{TRUE}, the y axis will always be hidden.}

\item{space}{numerical. Spacing between groups. If \code{NULL} (default), the spacing will be automatically calculated to avoid overlapping.}

\item{col.group}{the color used for group(s).}

\item{col.mark}{the color used for marker(s).}

\item{col.tag}{the color used for highlighted marker(s) and its/theirs label(s).}

\item{output}{the name of the output file. The file format can be specified by adding its extension. Available formats: 'bmp', 'jpeg', 'png', 'tiff', 'pdf' and 'eps' (default).}
}
\description{
Provides a simple draw of a linkage map.
}
\examples{

\dontrun{
 data("onemap_example_out")
 twopt <- rf_2pts(onemap_example_out)
 lg<-group(make_seq(twopt, "all"))
 seq1<-make_seq(order_seq(input.seq= make_seq(lg,1),twopt.alg = "rcd"), "force")
 seq2<-make_seq(order_seq(input.seq= make_seq(lg,2),twopt.alg = "rcd"), "force")
 seq3<-make_seq(order_seq(input.seq= make_seq(lg,3),twopt.alg = "rcd"), "force")
 draw_map2(seq1,seq2,seq3,tag = c("M1","M2","M3","M4","M5"))
 
 data("onemap_example_f2")
 twopt <- rf_2pts(onemap_example_f2)
 lg<-group(make_seq(twopt, "all"))
 seq<-list(
 make_seq(order_seq(input.seq= make_seq(lg,1),twopt.alg = "rcd"), "force"),
 make_seq(order_seq(input.seq= make_seq(lg,2),twopt.alg = "rcd"), "force"),
 make_seq(order_seq(input.seq= make_seq(lg,3),twopt.alg = "rcd"), "force")
 )
 draw_map2(seq,tag = "all",group.names = c("Chr 1","Chr 2","Chr 3"),main="Linkage Map")

}
}
\author{
Getulio Caixeta Ferreira, \email{getulio.caifer@gmail.com}
}
\keyword{rqtl}
