% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attributes.R
\name{list_omx}
\alias{list_omx}
\title{List the contents of an OMX file}
\usage{
list_omx(file)
}
\arguments{
\item{file}{The path to the OMX file.}
}
\value{
A list with 5 elements:
\describe{
  \item{Version}{the OMX version number}
  \item{Rows}{The number of rows in the matrix.}
  \item{Columns}{The number of columns in the matrix.}
  \item{Matrices}{A \code{data.frame} identifying the matrices and their
  attributes}
  \item{Lookups}{A \code{data.frame} identifying the lookups and their
  attributes.}
 }
}
\description{
List the contents of an OMX file
}
\examples{
omxfile <- omxr_example("skims.omx")
list_omx(omxfile)

}
