% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-model.R
\name{add_constraint}
\alias{add_constraint}
\alias{add_constraint_}
\title{Add a constraint}
\usage{
add_constraint(.model, .constraint_expr, ..., .show_progress_bar = TRUE)

add_constraint_(.model, .constraint_expr, ..., .dots,
  .show_progress_bar = TRUE)
}
\arguments{
\item{.model}{the model}

\item{.constraint_expr}{the constraint. Must be a linear (in)equality with
operator "<=", "==" or ">=".}

\item{...}{quantifiers for the indexed variables. For all combinations of
bound variables a new constraint is created. In addition
you can add filter expressions}

\item{.show_progress_bar}{displays a progressbar when adding multiple
constraints}

\item{.dots}{Used to work around non-standard evaluation.}
}
\value{
a Model with new constraints added
}
\description{
Add one or more constraints to the model using quantifiers.
}
\examples{
library(magrittr)
MIPModel() \%>\%
 add_variable(x[i], i = 1:5) \%>\%
 add_constraint(x[i] >= 1, i = 1:5) # creates 5 constraints

}
