% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ols-stepaic-backward-regression.R
\name{ols_step_backward_aic}
\alias{ols_step_backward_aic}
\alias{ols_step_backward_aic.default}
\alias{plot.ols_step_backward_aic}
\alias{ols_stepaic_backward}
\title{Stepwise AIC backward regression}
\usage{
ols_step_backward_aic(model, ...)

\method{ols_step_backward_aic}{default}(model, details = FALSE, ...)

\method{plot}{ols_step_backward_aic}(x, ...)
}
\arguments{
\item{model}{An object of class \code{lm}; the model should include all
candidate predictor variables.}

\item{...}{Other arguments.}

\item{details}{Logical; if \code{TRUE}, will print the regression result at
each step.}

\item{x}{An object of class \code{ols_step_backward_aic}.}
}
\value{
\code{ols_step_backward_aic} returns an object of class \code{"ols_step_backward_aic"}.
An object of class \code{"ols_step_backward_aic"} is a list containing the
following components:

\item{steps}{total number of steps}
\item{predictors}{variables removed from the model}
\item{aics}{akaike information criteria}
\item{ess}{error sum of squares}
\item{rss}{regression sum of squares}
\item{rsq}{rsquare}
\item{arsq}{adjusted rsquare}
}
\description{
Build regression model from a set of candidate predictor variables by
removing predictors based on akaike information criterion, in a stepwise
manner until there is no variable left to remove any more.
}
\section{Deprecated Function}{

\code{ols_stepaic_backward()} has been deprecated. Instead use \code{ols_step_backward_aic()}.
}

\examples{
\dontrun{
# stepwise backward regression
model <- lm(y ~ ., data = surgical)
ols_step_backward_aic(model)
}

\dontrun{
# stepwise backward regression plot
model <- lm(y ~ ., data = surgical)
k <- ols_step_backward_aic(model)
plot(k)
}

}
\references{
Venables, W. N. and Ripley, B. D. (2002) Modern Applied Statistics with S. Fourth edition. Springer.
}
\seealso{
Other variable selection procedures: \code{\link{ols_step_all_possible}},
  \code{\link{ols_step_backward_p}},
  \code{\link{ols_step_best_subset}},
  \code{\link{ols_step_both_aic}},
  \code{\link{ols_step_forward_aic}},
  \code{\link{ols_step_forward_p}}
}
