% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ols-normality-tests.R
\name{ols_norm_test}
\alias{ols_norm_test}
\alias{ols_norm_test.lm}
\title{Test for normality}
\usage{
ols_norm_test(y, ...)

\method{ols_norm_test}{lm}(y, ...)
}
\arguments{
\item{y}{a numeric vector or an object of class \code{lm}}

\item{...}{other arguments}
}
\value{
\code{norm_test} returns an object of class \code{"norm_test"}.
An object of class \code{"norm_test"} is a list containing the
following components:

\item{kolmogorv}{kolmogorv smirnov statistic}
\item{shapiro}{shapiro wilk statistic}
\item{cramer}{cramer von mises statistic}
\item{anderson}{anderson darling statistic}
}
\description{
Test for detecting violation of normality assumption.
}
\examples{
model <- lm(mpg ~ disp + hp + wt + qsec, data = mtcars)
ols_norm_test(model)
}

