% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scrapers.R
\name{get_issues_from_archive}
\alias{get_issues_from_archive}
\title{Scraps an OJS issues archive and retrieves the issues' url}
\usage{
get_issues_from_archive(input_url, verbose = FALSE)
}
\arguments{
\item{input_url}{Character vector.}

\item{verbose}{Logical.}
}
\value{
A long-format dataframe with the url you provided (input_url) and the url of issues found (output_url)
}
\description{
Takes a vector of OJS urls and scraps their archive of issues to retrieve links to OJS issues.
}
\examples{
\donttest{
journals <- c(
  'https://dspace.palermo.edu/ojs/index.php/psicodebate/issue/archive',
  'https://publicaciones.sociales.uba.ar/index.php/psicologiasocial/article/view/2903'
)
issues <- ojsr::get_issues_from_archive(input_url = journals, verbose = TRUE)
}

}
