% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ph_location.R
\name{resolve_location}
\alias{resolve_location}
\title{Resolve short form location}
\usage{
resolve_location(x)
}
\description{
Convert short form location format, a numeric or a string (e.g. \code{"body [1]"}),
into its corresponding location object. Under the hood, we parse the short form location and
call the corresponding function from the \verb{ph_location_*} family. Note that short forms may not
cover all function from the \verb{ph_location_*} and offer less customization.
}
\section{Short forms}{

The following location short forms are implemented. The corresponding call of the function from the
\verb{ph_location_*} family is displayed on the right.\tabular{lll}{
   \strong{Short form} \tab \strong{Description} \tab \strong{Location function} \cr
   \code{"left"} \tab Keyword string \tab \code{ph_location_left()} \cr
   \code{"right"} \tab Keyword string \tab \code{ph_location_right()} \cr
   \code{"fullsize"} \tab Keyword string \tab \code{ph_location_fullsize()} \cr
   \code{"body [1]"} \tab String: type + index in brackets (\code{1} if omitted) \tab \code{ph_location_type("body", 1)} \cr
   \code{"my_label"} \tab Any string not matching a keyword or type \tab \code{ph_location_label("my_label")} \cr
   \code{2} \tab Length 1 integer \tab \code{ph_location_id(2)} \cr
   \code{c(0,0,4,5)} \tab Length 4 numeric, optionally named, \code{c(top=0, left=0, ...)} \tab \code{ph_location(0, 0, 4, 5)} \cr
}
}

\examples{
resolve_location("left")
resolve_location("right")
resolve_location("fullsize")
resolve_location("body")
resolve_location("body [1]")
resolve_location("<some label>")
resolve_location(2)
resolve_location(c(0, 0, 4, 5))

}
\keyword{internal}
