% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cot_objects.R
\name{external_img}
\alias{external_img}
\alias{dim.external_img}
\alias{as.data.frame.external_img}
\alias{format.external_img}
\title{external image}
\usage{
external_img(src, width = 0.5, height = 0.2)

\method{dim}{external_img}(x)

\method{as.data.frame}{external_img}(x, ...)

\method{format}{external_img}(x, type = "console", ...)
}
\arguments{
\item{src}{image file path}

\item{width}{height in inches}

\item{height}{height in inches}

\item{x}{\code{external_img} object}

\item{...}{unused}

\item{type}{output format}
}
\description{
This function is used to insert images in 'PowerPoint'
slides.
}
\examples{
img.file <- file.path( R.home("doc"), "html", "logo.jpg" )

doc <- read_pptx()
doc <- add_slide(doc)
doc <- ph_with(x = doc,
  value = external_img(img.file, width = 1.39, height = 1.06),
  location = ph_location_type(type = "body"),
  use_loc_size = FALSE )
print(doc, target = tempfile(fileext = ".pptx"))
}
\seealso{
\link{ph_with}
}
