% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ph_location.R
\name{ph_location_type}
\alias{ph_location_type}
\title{location of a placeholder type}
\usage{
ph_location_type(type = "body", position_right = TRUE,
  position_top = TRUE, ...)
}
\arguments{
\item{type}{placeholder type to look for in the slide layout, one
of 'body', 'title', 'ctrTitle', 'subTitle', 'dt', 'ftr', 'sldNum'.}

\item{position_right}{the parameter is used when a selection with above
parameters does not provide a unique position (for example
layout 'Two Content' contains two element of type 'body').
If \code{TRUE}, the element the most on the right side will be selected,
otherwise the element the most on the left side will be selected.}

\item{position_top}{same than \code{position_right} but applied
to top versus bottom.}

\item{...}{unused arguments}
}
\description{
The function will use the type name of the placeholder (e.g. body, title),
the layout name and few other criterias to find the corresponding location.
}
\details{
The location of the bounding box associated to a placeholder
within a presentation slide is specified with the left top coordinate,
the width and the height. These are defined in inches:

\describe{
\item{left}{left coordinate of the bounding box}
\item{top}{top coordinate of the bounding box}
\item{width}{width of the bounding box}
\item{height}{height of the bounding box}
}

In addition to these attributes, there is attribute \code{ph_label}
associated with the shape (shapes, text boxes, images and other objects
will be identified with that label in the Selection Pane of PowerPoint).
This label can then be reused by other functions such as \code{ph_add_fpar},
or \code{ph_add_text}.
}
\examples{
library(magrittr)
read_pptx() \%>\%
  add_slide(layout = "Title and Content", master = "Office Theme") \%>\%
  ph_with("Hello world", location = ph_location_type(type = "body") ) \%>\%
  print(target = tempfile(fileext = ".pptx") )
}
\seealso{
Other functions for placeholder location: \code{\link{ph_location_fullsize}},
  \code{\link{ph_location_label}},
  \code{\link{ph_location_left}},
  \code{\link{ph_location_right}},
  \code{\link{ph_location}}
}
\concept{functions for placeholder location}
