% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv_oem.R
\name{cv.oem}
\alias{cv.oem}
\title{Orthogonalizing EM}
\usage{
cv.oem(x, y, penalty = c("elastic.net", "lasso", "ols", "mcp", "scad",
  "mcp.net", "scad.net", "grp.lasso", "grp.lasso.net", "grp.mcp", "grp.scad",
  "grp.mcp.net", "grp.scad.net", "sparse.grp.lasso"), weights = numeric(0),
  lambda = NULL, type.measure = c("mse", "deviance", "class", "auc", "mae"),
  nfolds = 10, foldid = NULL, grouped = TRUE, keep = FALSE,
  parallel = FALSE, ncores = -1, ...)
}
\arguments{
\item{x}{input matrix of dimension n x p or \code{CsparseMatrix} objects of the \pkg{Matrix} (sparse not yet implemented. 
Each row is an observation, each column corresponds to a covariate. The cv.oem() function
is optimized for n >> p settings and may be very slow when p > n, so please use other packages
such as \code{glmnet}, \code{ncvreg}, \code{grpreg}, or \code{gglasso} when p > n or p approx n.}

\item{y}{numeric response vector of length nobs.}

\item{penalty}{Specification of penalty type in lowercase letters. Choices include \code{"lasso"}, 
\code{"ols"} (Ordinary least squares, no penaly), \code{"elastic.net"}, \code{"scad"}, \code{"mcp"}, \code{"grp.lasso"}}

\item{weights}{observation weights. defaults to 1 for each observation (setting weight vector to 
length 0 will default all weights to 1)}

\item{lambda}{A user supplied lambda sequence. By default, the program computes
its own lambda sequence based on nlambda and lambda.min.ratio. Supplying
a value of lambda overrides this.}

\item{type.measure}{measure to evaluate for cross-validation. The default is \code{type.measure = "deviance"}, 
which uses squared-error for gaussian models (a.k.a \code{type.measure = "mse"} there), deviance for logistic
regression. \code{type.measure = "class"} applies to binomial only. \code{type.measure = "auc"} is for two-class logistic 
regression only. \code{type.measure = "mse"} or \code{type.measure = "mae"} (mean absolute error) can be used by all models;
they measure the deviation from the fitted mean to the response.}

\item{nfolds}{number of folds for cross-validation. default is 10. 3 is smallest value allowed.}

\item{foldid}{an optional vector of values between 1 and nfold specifying which fold each observation belongs to.}

\item{grouped}{Like in \pkg{glmnet}, this is an experimental argument, with default \code{TRUE}, and can be ignored by most users. 
For all models, this refers to computing nfolds separate statistics, and then using their mean and estimated standard 
error to describe the CV curve. If \code{grouped = FALSE}, an error matrix is built up at the observation level from the 
predictions from the \code{nfold} fits, and then summarized (does not apply to \code{type.measure = "auc"}).}

\item{keep}{If \code{keep = TRUE}, a prevalidated list of arrasy is returned containing fitted values for each observation 
and each value of lambda for each model. This means these fits are computed with this observation and the rest of its
fold omitted. The folid vector is also returned. Default is \code{keep = FALSE}}

\item{parallel}{If TRUE, use parallel foreach to fit each fold. Must register parallel before hand, such as \pkg{doMC}.}

\item{ncores}{Number of cores to use. If \code{parallel = TRUE}, then ncores will be automatically set to 1 to prevent conflicts}

\item{...}{other parameters to be passed to \code{"oem"} function}
}
\value{
An object with S3 class \code{"cv.oem"}
}
\description{
Orthogonalizing EM
}
\examples{
set.seed(123)
n.obs <- 1e4
n.vars <- 100

true.beta <- c(runif(15, -0.25, 0.25), rep(0, n.vars - 15))

x <- matrix(rnorm(n.obs * n.vars), n.obs, n.vars)
y <- rnorm(n.obs, sd = 3) + x \%*\% true.beta

fit <- cv.oem(x = x, y = y, 
              penalty = c("lasso", "grp.lasso"), 
              groups = rep(1:20, each = 5))

layout(matrix(1:2, ncol = 2))
plot(fit)
plot(fit, which.model = 2)
}
