% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_resource.R
\name{get_resource}
\alias{get_resource}
\title{Get selected resources or all resources within a package.}
\usage{
get_resource(package, resource = NULL, limit = Inf)
}
\arguments{
\item{package}{A character of length 1 specifying a package id or name which
identifies the package for which all resources should be returned or
containing the resource/s identified in the resource argument. Only one
package may be specified.}

\item{resource}{Optionally, a character vector specifying resource id/s of
the data set/s to be returned. Multiple resources within the same package
can be specified.}

\item{limit}{A numeric value specifying the maximum number of rows to be
returned. Default value \code{Inf} returns all rows.}
}
\value{
A list containing all the resources within a package, or those
specified, as data.frames.
}
\description{
Get data from one or more resources, or all resources within a
package, as a list, with each resource in tabular format. Where field
selection and/or filtering of data is required the
\code{get_data} function can be used.
}
\examples{
\dontrun{
get_resource(
  package = "4dd86111-7326-48c4-8763-8cc4aa190c3e",
  limit = 5L
  )
  
get_resource(
  package = "4dd86111-7326-48c4-8763-8cc4aa190c3e",
  resource = "edee9731-daf7-4e0d-b525-e4c1469b8f69",
  limit = 5L
  )

get_resource(
  package = "standard-populations",
  resource = "edee9731-daf7-4e0d-b525-e4c1469b8f69",
  limit = 5L
  )
}
 
}
