% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_help.R
\name{get_help}
\alias{get_help}
\title{get_help}
\usage{
get_help(target = "", briefcase = "odkBriefcase_latest")
}
\arguments{
\item{target}{Path to directory of ODK Briefcase \code{.jar} file. Directory
path should match directory path used when calling \code{get_briefcase()}.
If ODK Briefcase \code{.jar} file was downloaded manually from \url{https://opendatakit.org},
\code{target} should match the directory path where \code{.jar} file has
been downloaded into.}

\item{briefcase}{Filename of the downloaded ODK Briefcase \code{.jar} file.
Default is \code{odkBriefcase_latest} to match the default filename used
by \code{get_briefcase()}. If ODK Briefcase \code{.jar} file was
downloaded manually from \url{https://opendatakit.org}, filename should
match the default filename used by Open Data Kit which is usually
"ODK Briefcase vX.Y.Z Production.jar" where vX.Y.Z is the version number}
}
\value{
Help notes on usage of ODK Briefcase via command line interface
}
\description{
Get help with command line interface for ODK Briefcase
}
\examples{
\dontrun{
  dirPath <- tempdir()
  get_briefcase(destination = dirPath)
  get_help(target = dirPath)
}
}
