% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/odeintr.R
\name{set_optimization}
\alias{rm.Makevars}
\alias{set_optimization}
\alias{show.Makevars}
\title{Set compiler optimization}
\usage{
set_optimization(level = 3, omit.debug = FALSE, disable.asserts = FALSE,
  suppress.warnings = FALSE, overwrite = FALSE)

show.Makevars()

rm.Makevars()
}
\arguments{
\item{level}{the compiler optimization level (-O<level>)}

\item{omit.debug}{if true, remove "-g" from flags}

\item{disable.asserts}{if true, set NDEBUG define}

\item{suppress.warnings}{if true, suppress compiler warnings}

\item{overwrite}{if true, overwrite existing Makevars file}
}
\description{
Write a user Makevars with updated optimization level
}
\details{
This function will change the optimization flags used
when compiling code. It will write the file "Makevars" to the
".R" directory in your "$HOME" directory. These setting will
effect all subsequent compiles, even package installation,
unless you remove or edit the "Makevars" file.

This function assumes that your compiler uses "-O" to
indicate optimization level and "-g" to indicate that
the compiler should issue debugging symbols.

Please let me know if this function fails for your
compiler. (Submit and issue on GitHub.)
}
\note{
Don't go overboard. Levels greater than 3 can be
hazardous to numerical accuracy. Some packages will not
compile or will give inaccurate results for levels above 2.

A very similar function exists in the RStan package.
}
\author{
Timothy H. Keitt
}
\seealso{
\code{\link{compile_sys}}
}

