% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_funs.R
\name{gam_to_df}
\alias{gam_to_df}
\title{Converts a fitted GAM model into a tidy data frame}
\usage{
gam_to_df(model = NULL, pred = NULL)
}
\arguments{
\item{model}{A fitted GAM(M).}

\item{pred}{Character. Predictor name for which to calculate the odds ratio.}
}
\description{
This function converts a fitted GAM model into a tidy data frame
}
\details{
To be able to plot the smoothing function of a GAM using ggplot2,
some preprocessing is needed coming from the raw fitted GAM model output.

Used in \link{plot_gam}.
}
\examples{
# load data (Source: ?mgcv::gam)
library(mgcv)
n <- 200
sig <- 2
dat <- gamSim(1, n = n, scale = sig, verbose = FALSE)
dat$x4 <- as.factor(c(
  rep("A", 50), rep("B", 50), rep("C", 50),
  rep("D", 50)
))
fit_gam <- gam(y ~ s(x0) + s(I(x1^2)) + s(x2) +
  offset(x3) + x4, data = dat) # fit model

tmp <- gam_to_df(fit_gam, "x2")
}
\seealso{
\link{plot_gam}
}
\author{
Patrick Schratz
}
\keyword{internal}
