% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.oceCoxph.R
\name{plot.oceCoxph}
\alias{plot.oceCoxph}
\title{Plot \code{oceNPMLE} object.}
\usage{
\method{plot}{oceCoxph}(
  x,
  linesonly = FALSE,
  xlab = "Ordering Score",
  ylab = "Proportion with a larger ordering score",
  col = c("red", "blue"),
  ...
)
}
\arguments{
\item{x}{oceCoxph object (see \code{\link{oceCoxph}}).}

\item{linesonly}{logical, add lines to an existing plot?}

\item{xlab}{x label}

\item{ylab}{y label}

\item{col}{color vector, col[1] for group=0 and col[2] for group=1.}

\item{...}{Extra arguments (e.g., lwd=3) added to both \code{lines} functions.}
}
\value{
The function invisibly (see \code{\link[base]{invisible}}) returns
  a list with 4 elements: (time0, surv0, time1, and surv1)
}
\description{
Plot \code{oceNPMLE} object.
}
\examples{
# need to first run oceFormat and oceCoxph
data(simScenario5)
dataFormt<-oceFormat(data=simScenario5, oceTime=c("T1","T2","T3"),
   oceStatus=c("I1","I2","I3"), group=c("Z"),
   oceNames = c("Death","Stroke/MI","Bleed"))
coxOutput<- oceCoxph(dataFormt)
plot(coxOutput, xlab="Custom x label")

}
\seealso{
Example in \code{\link{plot.oceNPMLE}} shows adding lines from
  the coxph output to an existing plot.
}
