% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colors.R
\name{colormapGMT}
\alias{colormapGMT}
\title{Create a GMT-type (CPT) colormap}
\usage{
colormapGMT(name, debug = getOption("oceDebug"))
}
\arguments{
\item{name}{character value specifying the GMT scheme, or a source for such
a scheme. Four pre-defined schemes are available, accessed by setting \code{name} to
\code{"gmt_gebco"}, \code{"gmt_globe"}, \code{"gmt_ocean"}, or \code{"gmt_relief"}. If \code{name} is
not one of these values, then it is taken to be the name of a local file
in GMT format or, if no such file is found, a URL holding such a file.}

\item{debug}{integer that, if positive, indicates to print some debugging output}
}
\value{
\code{colormap} returns a list, in the same format as the return value for \code{\link[=colormap]{colormap()}}.
}
\description{
\code{colormapGMT} creates colormaps in the Generic Mapping Tools (GMT)
scheme (see References 1 to 4).  A few such schemes are built-in, and may be referred to
by name (\code{"gmt_gebco"}, \code{"gmt_globe"}, \code{"gmt_ocean"}, or \code{"gmt_relief"})
while others are handled by reading local files that are in GMT
format, or URLs providing such files (see Reference 3).
}
\details{
The GMT files understood by \link{colormapGMT} are what GMT calls
"Regular CPT files" (see reference 4).  This is a text format that
can be read and (with care) edited in a text editor.  There
are three categories of lines within this file.  (1) Any
line starting with the \code{"#"} character is a comment, and is ignored
by \link{colormapGMT}. (2) Lines with 8 numbers specify colour bands.
The first number is a z value, and the three numbers after that
are red, green and blue values in the range from 0 to 255. This
set of 4 numbers is followed on the same line with similar values.
Think of this sequence as describing a band of colours between
two z values. (3) Lines starting with a character, followed
by three numbers, specify particular codings.  The character \code{"B"}
specifies background colour, while \code{"F"} specifies foreground
colour, and \code{"N"} specifies the colour to be used for missing
data (the letter stands for not-a-number).  Only \code{"N"} is used
by \link{colormapGMT}, and it takes on the role that the \code{missingColor}
argument would otherwise have.  (This is why \code{missingColor} is not
permitted if \code{name} is given.)
}
\references{
\enumerate{
\item General overview of GMT system
\url{https://www.generic-mapping-tools.org}.
\item Information on GMT color schemes
\url{https://docs.generic-mapping-tools.org/dev/cookbook/cpts.html}
\item Source of GMT specification files
https://beamreach.org/maps/gmt/share/cpt/ (this link worked
for years, but failed to respond in October 2021)
\item CPT (color palette table) format
\url{https://www.soest.hawaii.edu/gmt/gmt/html/GMT_Docs.html#x1-820004.15}
}
}
\seealso{
Other things related to colors: 
\code{\link{colormap}()},
\code{\link{oceColors9B}()},
\code{\link{oceColorsCDOM}()},
\code{\link{oceColorsChlorophyll}()},
\code{\link{oceColorsClosure}()},
\code{\link{oceColorsDensity}()},
\code{\link{oceColorsFreesurface}()},
\code{\link{oceColorsGebco}()},
\code{\link{oceColorsJet}()},
\code{\link{oceColorsOxygen}()},
\code{\link{oceColorsPAR}()},
\code{\link{oceColorsPalette}()},
\code{\link{oceColorsPhase}()},
\code{\link{oceColorsSalinity}()},
\code{\link{oceColorsTemperature}()},
\code{\link{oceColorsTurbidity}()},
\code{\link{oceColorsTurbo}()},
\code{\link{oceColorsTwo}()},
\code{\link{oceColorsVelocity}()},
\code{\link{oceColorsViridis}()},
\code{\link{oceColorsVorticity}()},
\code{\link{ocecolors}}
}
\author{
Dan Kelley
}
\concept{things related to colors}
