% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tides.R
\name{tidemAstron}
\alias{tidemAstron}
\title{Astronomical Calculations for Tidem}
\usage{
tidemAstron(t)
}
\arguments{
\item{t}{Either a time in \code{POSIXct} format (with \code{"UTC"} timezone,
or else odd behaviours may result),
or an integer. In the second case, it is converted to a time with
\code{\link[=numberAsPOSIXct]{numberAsPOSIXct()}}, using \code{tz="UTC"}.}
}
\value{
A \code{list} containing items named
\code{astro} and \code{ader} (see the \code{T_TIDE} documentation).
}
\description{
Do some astronomical calculations for \code{\link[=tidem]{tidem()}}.  This function is based directly
on \code{t_astron} in the \code{T_TIDE} Matlab package (see Pawlowicz et al. 2002),
which inherits from the Fortran code described by Foreman (1978).
}
\examples{
tidemAstron(as.POSIXct("2008-01-22 18:50:24"))

}
\references{
\itemize{
\item Foreman, M. G. G., 1978. Manual for Tidal Currents Analysis and Prediction.
Pacific Marine Science Report. British Columbia, Canada: Institute of Ocean
Sciences, Patricia Bay.
\item Pawlowicz, Rich, Bob Beardsley, and Steve Lentz, 2002.  Classical tidal
harmonic analysis including error estimates in MATLAB using \code{T_TIDE}.
Computers and Geosciences, 28, 929-937.
}
}
\seealso{
Other things related to tides: 
\code{\link{[[,tidem-method}},
\code{\link{[[<-,tidem-method}},
\code{\link{as.tidem}()},
\code{\link{plot,tidem-method}},
\code{\link{predict.tidem}()},
\code{\link{summary,tidem-method}},
\code{\link{tidalCurrent}},
\code{\link{tidedata}},
\code{\link{tidem-class}},
\code{\link{tidemVuf}()},
\code{\link{tidem}},
\code{\link{webtide}()}
}
\author{
Dan Kelley translated this from the \code{t_astron} function
of the \code{T_TIDE} Matlab package (see Pawlowicz et al. 2002).
}
\concept{things related to tides}
