% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/suggestions.R
\name{get_suggestion_info}
\alias{get_suggestion_info}
\title{Get additional information for a suggestion id.}
\usage{
get_suggestion_info(
  suggestion_ids,
  suggestion_type = "auxco-1.2.x",
  suggestion_type_options = list(),
  include_default_codes = FALSE
)
}
\arguments{
\item{suggestion_ids}{Suggestion id(s) to retrieve information for.
This should typically be a character vector.}

\item{suggestion_type}{Which suggestion type is being used.
Only auxco-based suggestion_types are supported.}

\item{suggestion_type_options}{A list with options for generating
suggestions. Supported options:
- \code{datasets}: Pass specific datasets to be used whenn adding information
to predictions e.g. use a specific version of the kldb or auxco.
Supported datasets are: "auxco-1.2.x", "kldb-2010". By default the datasets
bundled with this package are used.}

\item{include_default_codes}{Whether default id encodings should be returned
with the rest of infromation e.g. KldB-IDs. Defaults to FALSE.
(Only for internal use, use \code{\link[=get_final_codes]{get_final_codes()}} to get codes)}
}
\value{
Data table with information about the suggestion.
}
\description{
This includes a descriptive title, job descriptions etc.
To retrieve information regarding followup questions use
\link{get_followup_questions}.
}
\examples{
\dontshow{data.table::setDTthreads(1)}

\dontrun{
get_suggestion_info("9079")
}
}
\keyword{internal}
