% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter.R
\name{occFilter}
\alias{occFilter}
\title{Filter occurrence records from occTest outputs}
\usage{
occFilter(
  df,
  by = "testBlock",
  errorAcceptance = "relaxed",
  errorThreshold = NULL,
  custom = NULL
)
}
\arguments{
\item{df}{data.frame. Output of  occTest}

\item{by}{character. Applying thresholds to either  blocks of test ('testBlock') or single test types ('testType')}

\item{errorAcceptance}{character. Philosophy for filtering based on threshold. Option are majority, relaxed, strict. Default are 'relaxed'}

\item{errorThreshold}{double. Value from 0 to 1, specifying the threshold of wrong tests (potentally erroneous records) to filter. It overrides the parameters in thresholds. We recommend building that table based on the functio buildCustomThresholds.}

\item{custom}{data.frame or equivalent, custom rules created adding a "errorThreshold" (ranging from 0, strict, to 1, relaxed) column to to the result of readRDS(system.file('ext/fieldMetadata.rds',package='occTest'))}
}
\value{
list of 2 data.frames
}
\description{
Select occurrence records based on aggregated values of different tests
}
\details{
If errorAcceptance is used, a 'relaxed' philosophy corresponds to 0.7 (70% of tests of a block or type not passed), 'majority' corresponds to an errorAcceptance of 0.5, 'strict' corresponds to an errorAcceptance of 0.2.
}
\examples{

### THIS IS A CUT DOWN  EXAMPLE 
### visit vignetteXtra-occTest for more info

#load output from occTest
occTest_output <- readRDS (system.file('ext/out.rds',package = 'occTest'))
filtered_dataset <- occFilter (occTest_output)
#inspect results
names (filtered_dataset)

}
\seealso{
showTests
}
\author{
Josep M Serra-Diaz (pep.serradiaz@agroparistech.fr), Jeremy Borderieux (jeremy.borderieux@agroparistech.fr)
}
\keyword{filter}
