% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ob-analytics.R
\docType{package}
\name{obAnalytics-package}
\alias{obAnalytics}
\alias{obAnalytics-package}
\title{obAnalytics.}
\description{
Limit order book analytics.
}
\section{Main functionality}{


\itemize{
  \item Limit order book event processing.
  \item Visualise order book state and market impacts.
  \item Order book reconstruction and analysis.
}
}

\section{Data processing}{


The main focus of this package is reconstruction of a limit order book. 
The \code{\link{processData}} function will perform data processing based on
a supplied CSV file, the schema of which is defined in the
\code{\link{processData}} function documentation. Example preprocessed limit
order data are also provided (see \code{\link{lob.data}}) which has been
derived from the example raw data provided the inst/extdata directory.

The data processing consists of a number of stages:

\itemize{
  \item Cleaning of duplicate and erroneous data.
  \item Identification of sequential event relationships.
  \item Inference of trade events via order-matching.
  \item Inference of order types (limit vs market).
  \item Construction of volume by price level series.
  \item Construction of order book summary statistics.
}

Limit order events are related to one another by \emph{volume deltas} (the
change in volume for a limit order). To simulate a matching-engine, and thus
determine directional trade data, volume deltas from both sides of the limit
order book are ordered by time, yielding a sequence alignment problem, to
which the the
\href{https://en.wikipedia.org/wiki/Needleman-Wunsch_algorithm}{Needleman-Wunsch}
algorithm has been applied.
}

\section{Visualisation}{


The package provides a number of functions for the visualisation of limit
order events and order book liquidity. The visualisations all make use of
the \href{http://ggplot2.org}{ggplot2} plotting system:

\describe{
  \item{\link{plotTimeSeries}}{General time series plotting.}
  \item{\link{plotTrades}}{Plot \code{\link{trades}} data.}
  \item{\link{plotCurrentDepth}}{Visualise the \emph{shape} of an
\code{\link{orderBook}}.}
  \item{\link{plotPriceLevels}}{Visualise volume by price level through
time.}
  \item{\link{plotVolumePercentiles}}{Visualise order book liquidity through
time.}
  \item{\link{plotEventMap}}{Visualise sequential limit order events by price
level.}
  \item{\link{plotVolumeMap}}{Visualise sequential limit order events by
volume.}
  \item{\link{plotEventsHistogram}}{Convenience function.}
}

The \code{\link{plotPriceLevels}} visualisation is designed to show the
\emph{ebb and flow} of limit order volume at all price levels including the
interplay between the bid/ask spread. It is possible to identify interesting
market participant behaviour and to visualise market shocks and resilience
with this function.

The \code{\link{plotEventMap}} function is useful for studying systematic
market participant behaviour. Interesting sequential patterns can be observed
in this visualisation as algorithms react to various market events by
repositioning orders.

The \code{\link{plotVolumeMap}} function shows a visualisation of cancelled
volume through time. It is possible to identify and filter out individual
trading algorithms from this graph.

The \code{\link{plotVolumePercentiles}} visualisation is inspired by the size
map chart included in many articles from
\href{http://www.nanex.net/NxResearch}{Nanex research} and is intended to
show available market liquidity.

In all visualisations it is possible to filter the data by time, price and
volume.
}

\section{Analysis}{


In addition to the generated \code{\link{lob.data}} which are intended to be
used as a basis for further research, the package currently provides a
limited set of trade and order book analysis functions:

\describe{
  \item{\link{filterDepth}}{Filter \code{\link{depth}} data by time period.}
  \item{\link{getSpread}}{Extract the bid/ask quotes from the
\code{\link{depth.summary}} data.}
  \item{\link{orderBook}}{Reconstruct a Limit order book from
\code{\link{events}} data.}
  \item{\link{tradeImpacts}}{Group \code{\link{trades}} into individual impact events.}
}

Additional functionality will be added to the package in the future.
}
\author{
Philip Stubbings \email{phil@parasec.net}
}
\references{
\url{http://parasec.net/transmission/order-book-visualisation}
}

