% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ob-analytics.R
\docType{data}
\name{events}
\alias{events}
\title{Limit order events.}
\format{A data.frame consisting of the following fields:
\describe{
  \item{event.id}{Event ID.}
  \item{id}{Limit Order ID.}
  \item{timestamp}{Local timestamp for order update (create/modify/delete).}
  \item{exchange.timestamp}{Exchange order creation time.}
  \item{price}{Limit order price level.}
  \item{volume}{Remaining limit order volume.}
  \item{action}{Event action: created, changed, deleted.}
  \item{direction}{Order book side: bid, ask.}
  \item{fill}{For changed or deleted events, indicates the change in volume.}
  \item{matching.event}{Matching \code{event.id} if this event is part of a
trade. \code{NA} otherwise.}
  \item{type}{Limit order type (see \emph{Event types} below.)}
  \item{aggressiveness.bps}{The distance of the order from the edge of the
book in Basis Points (BPS).}
}

Each limit order \emph{type} has been categorised as follows:

\describe{
  \item{unknown}{It was not possible to infer the order type given the
available data.}
  \item{flashed-limit}{Order was created then subsequently deleted. 96\% of
example data.}
  \item{resting-limit}{Order was created and left in order book indefinitely
until filled.}
  \item{market-limit}{Order was partially filled before landing in the order
book at it's limit price.}
  \item{market}{Order was completely filled and did not come to rest in the
order book.}
  \item{pacman}{A limit-price modified \emph{in situ} (exchange algorithmic
order).}
}}
\description{
A data.frame containing the lifecycle of limit orders.
}
\details{
The purpose of this table is to keep account of the lifecycle of all orders
in both sides of the limit order book. The lifecycle of an individual limit
order follows a sequence of events:

\describe{
  \item{created}{The order is created with a specified amount of volume and
a limit price.}
  \item{changed}{The order has been partially filled. On each modification, 
the remaining volume will decrease.}
  \item{deleted}{The order may be deleted at the request of the trader or, in
the event that the order has been completely filled, deleted by the exchange.
An order deleted by the exchange as a result of being filled will have 0
remaining volume at time of deletion.}
}
}
\author{
phil
}
\seealso{
Other Limit.order.book.data: \code{\link{depth.summary}},
  \code{\link{depth}}, \code{\link{trades}}
}
\keyword{datasets}

