% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_comma.R
\name{f_comma}
\alias{f_comma}
\alias{ff_comma}
\title{Comma Format Large Integers}
\usage{
f_comma(x, mark = ",", prefix = "", ...)

ff_comma(...)
}
\arguments{
\item{x}{A vector of numbers (or string equivalents).}

\item{mark}{The character to include every n places.}

\item{prefix}{A string to append to the front of elements.}

\item{\ldots}{Other arguments passed to \code{\link[base]{prettyNum}}.}
}
\value{
Returns a comma separted string of publication ready digits.
}
\description{
Add commas to larger integers.
}
\examples{
set.seed(4)
f_comma(sample(4:10, 5)^5)
f_comma(c(1234.12345, 1234567890, .000034034, 123000000000, -1234567))
}
\seealso{
\code{\link[base]{prettyNum}}
}
