% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/levy_recovery.R
\name{fit_bm_compound_poisson}
\alias{fit_bm_compound_poisson}
\title{Fit Brownian motion mixture with Gaussian jumps.}
\usage{
fit_bm_compound_poisson(data, mesh_size, thresholds = NA, jump_quantile = 0.9)
}
\arguments{
\item{data}{Data to fit (increments).}

\item{mesh_size}{Time difference of data.}

\item{thresholds}{Jump thresholds (Defaults to \code{NA}, no filtering).}

\item{jump_quantile}{Quantile above which a data vector is a jump.}
}
\value{
List of fitted Generalised Hyperbolic distribution.
}
\description{
Fit Brownian motion mixture with Gaussian jumps.
}
\examples{
n <- 10000
delta_time <- 0.01
data <- cbind(ghyp::rghyp(n, ghyp::ghyp()), ghyp::rghyp(n, ghyp::ghyp()))
fit_bm_compound_poisson(data = data, mesh_size = delta_time)
}
