% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nsnbinom.R
\name{Neutrosophic Negative Binomial}
\alias{Neutrosophic Negative Binomial}
\alias{dnsnbinom}
\alias{pnsnbinom}
\alias{qnsnbinom}
\alias{rnsnbinom}
\title{Neutrosophic Negative Binomial Distribution}
\usage{
dnsnbinom(x, size, prob)

pnsnbinom(q, size, prob, lower.tail = TRUE)

qnsnbinom(p, size, prob)

rnsnbinom(n, size, prob)
}
\arguments{
\item{x}{a vector or matrix of observations for which the pdf needs to be computed.}

\item{size}{number of trials (zero or more), which must be a positive interval.}

\item{prob}{probability of success on each trial, \eqn{0 < prob <= 1}.}

\item{q}{a vector or matrix of quantiles for which the cdf needs to be computed.}

\item{lower.tail}{logical; if TRUE (default), probabilities are
\eqn{P(X \ge x)}; otherwise, \eqn{P(X >x)}.}

\item{p}{a vector or matrix of probabilities for which the quantile needs to be computed.}

\item{n}{number of random values to be generated.}
}
\value{
\code{pnsnbinom} gives the distribution function,
 \code{dnsnbinom} gives the density,
 \code{qnsnbinom} gives the quantile function and
 \code{rnsnbinom} generates random variables from the Negative Binomial Distribution.
}
\description{
Density, distribution function, quantile function and random
generation for the neutrosophic Negative Binomial distribution with
parameters \code{size} = \eqn{r_N} and \code{prob} = \eqn{p_N}.
}
\details{
The neutrosophic negative binomial distribution with parameters \eqn{r_N} and \eqn{p_N}
has the density
\deqn{\left(\begin{array}{c} r_N+x-1 \\ x \end{array}\right) p_N^{r_N}\left(1-p_N\right)^{x}}
for \eqn{r_N \in \{1, 2, \ldots\}} and \eqn{p_N \in (p_L, p_U)} which must be \eqn{0<p_N<1}
and \eqn{x \in \{0, 1, 2, \ldots\}}.
}
\examples{
dnsnbinom(x = 1, size = 2, prob = c(0.5, 0.6))
pnsnbinom(q = 1, size = 2, prob = c(0.5, 0.6))
qnsnbinom(p = c(0.25, 0.5, 0.75), size = 2, prob = c(0.5, 0.6))
rnsnbinom(n = 10, size = 2, prob = c(0.6, 0.6))
}
\references{
Granados, C. (2022).
       Some discrete neutrosophic distributions with neutrosophic parameters based on neutrosophic random variables.
        \emph{Hacettepe Journal of Mathematics and Statistics}, 51(5), 1442-1457.
}
