% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nsdunif.R
\name{Neutrosophic Discrete Uniform}
\alias{Neutrosophic Discrete Uniform}
\alias{dnsdunif}
\alias{pnsdunif}
\alias{qnsdunif}
\alias{rnsdunif}
\title{Neutrosophic Discrete Uniform Distribution}
\usage{
dnsdunif(x, k)

pnsdunif(q, k, lower.tail = TRUE)

qnsdunif(p, k)

rnsdunif(n, k)
}
\arguments{
\item{x}{a vector or matrix of observations for which the pdf needs to be computed.}

\item{k}{parameter of the distribution that must be a positive finite interval.}

\item{q}{a vector or matrix of quantiles for which the cdf needs to be computed.}

\item{lower.tail}{logical; if TRUE (default), probabilities are
\eqn{P(X \ge x)}; otherwise, \eqn{P(X >x)}.}

\item{p}{a vector or matrix of probabilities for which the quantile needs to be computed.}

\item{n}{number of random values to be generated.}
}
\value{
\code{pnsdunif} gives the distribution function,
 \code{dnsdunif} gives the density,
 \code{qnsdunif} gives the quantile function and
 \code{rnsdunif} generates random variables from the neutrosophic Discrete Uniform Distribution.
}
\description{
Density, distribution function, quantile function and random
generation for the nuetrosophic discrete uniform distribution with
parameter \eqn{k_N}.
}
\details{
Let \eqn{X_N} be a neutrosophic random variable and denote
\eqn{X_N \sim \mathcal{U}(1,2,\ldots,k_N)} as neutrosophic discrete
uniform distribution with parameter \eqn{k_N} has the density
\deqn{f_N(x)=\frac{1}{k_N}}
for \eqn{k_N \in (k_L, k_U)}.
}
\examples{
dnsdunif(x = 8, k = c(10, 11))
dnsdunif(x = c(8, 9), k = c(10, 11))

pnsdunif(q = 2, k = c(10, 11))

qnsdunif(p = 0.2, k = c(10, 11))


# Simulate 10 numbers
rnsdunif(n = 10, k = c(10, 11))

}
\references{
Granados, C. (2022). Some discrete neutrosophic distributions with
       neutrosophic parameters based on neutrosophic random variables.
        \emph{Hacettepe Journal of Mathematics and Statistics}, 51(5),
         1442-1457.
}
