% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/np.geo.R
\name{np.geo}
\alias{np.geo}
\alias{np.geo-class,}
\alias{fitgeo-class}
\title{Nonparametric geostatistical model (S3 class "np.geo")}
\usage{
np.geo(lp, svm, svm0 = NULL, nbin = lp$grid$n)
}
\arguments{
\item{lp}{local polynomial estimate of the trend function (object of class 
\code{\link{locpol.bin}}).}

\item{svm}{(fitted) variogram model (object of class 
\code{\link{fitsvar}} or \code{\link{svarmod}}).}

\item{svm0}{(fitted) residual variogram model (object of class 
\code{\link{fitsvar}} or \code{\link{svarmod}}).}

\item{nbin}{number of bins on each dimension.}
}
\value{
Returns an object of \code{\link{class}} \code{np.geo}
(extends \code{\link{locpol.bin}}), the \code{lp} argument with 
the others and the vector of residuals as additional components.
}
\description{
Defines a nonparametric geostatistical model 
(not intended to be used regularly; see \code{\link{np.fitgeo}}). 
Constructor function of the \code{np.geo} and \code{fitgeo} S3 \code{\link{class}}es.
}
\seealso{
\code{\link{np.fitgeo}}, \code{\link{locpol}}, \code{\link{fitsvar.sb.iso}}.
}
